/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentLikeRecordRepository;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeCommentLikeRecordService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeCommentLikeRecordService")
public class NoticeCommentLikeRecordServiceImpl
implements NoticeCommentLikeRecordService {
    @Autowired
    private NoticeCommentLikeRecordRepository noticeCommentLikeRecordRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NoticeCommentRepository noticeCommentRepository;

    @Override
    public Page<NoticeCommentLikeRecord> findByConditions(Pageable pageable, NoticeCommentLikeRecord noticeCommentLikeRecord) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)noticeCommentLikeRecord)) {
            noticeCommentLikeRecord = new NoticeCommentLikeRecord();
        }
        return this.noticeCommentLikeRecordRepository.findByConditions(pageable, noticeCommentLikeRecord);
    }

    @Override
    @Transactional
    public NoticeCommentLikeRecord createByCommentIdAndCurrentUser(String commentId) {
        NoticeCommentLikeRecord noticeCommentLikeRecord = new NoticeCommentLikeRecord();
        noticeCommentLikeRecord.setCommentId(commentId);
        this.createValidate(noticeCommentLikeRecord);
        this.noticeCommentLikeRecordRepository.saveOrUpdate((Object)noticeCommentLikeRecord);
        return noticeCommentLikeRecord;
    }

    @Override
    public void deleteByCurrentUser(String commentId) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        String userName = loginDetails.getAccount();
        NoticeCommentLikeRecord noticeCommentLikeRecord = this.noticeCommentLikeRecordRepository.findByUserNameAndCommentId(userName, commentId);
        Validate.notNull((Object)((Object)noticeCommentLikeRecord), (String)"\u60a8\u5f53\u524d\u672a\u70b9\u8d5e\uff01", (Object[])new Object[0]);
        this.noticeCommentLikeRecordRepository.deleteByUserName(userName);
    }

    private void createValidate(NoticeCommentLikeRecord noticeCommentLikeRecord) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        String account = loginDetails.getAccount();
        Validate.notNull((Object)((Object)noticeCommentLikeRecord), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        noticeCommentLikeRecord.setId(null);
        noticeCommentLikeRecord.setUserName(account);
        noticeCommentLikeRecord.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)noticeCommentLikeRecord.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)noticeCommentLikeRecord.getCommentId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8bc4\u8bbaid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)noticeCommentLikeRecord.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<NoticeComment> noticeComments = this.noticeCommentRepository.findByIds(Lists.newArrayList((Object[])new String[]{noticeCommentLikeRecord.getCommentId()}));
        Validate.isTrue((!CollectionUtils.isEmpty(noticeComments) ? 1 : 0) != 0, (String)"\u70b9\u8d5e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8bc4\u8bba\u4fe1\u606f\uff01", (Object[])new Object[0]);
        NoticeCommentLikeRecord commentLikeRecord = this.noticeCommentLikeRecordRepository.findByUserNameAndCommentId(account, noticeCommentLikeRecord.getCommentId());
        Validate.isTrue((commentLikeRecord == null ? 1 : 0) != 0, (String)"\u60a8\u5df2\u70b9\u8d5e\uff01", (Object[])new Object[0]);
    }
}

