package com.biz.crm.sfa.business.notice.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.service.NoticeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 公告表(Notice)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-27 14:17:38
 */
@RestController
@RequestMapping("/v1/notice/notice")
@Slf4j
@Api(tags = "公告管理：Notice：公告表")
public class NoticeController {
  /**
   * 服务对象
   */
  @Autowired
  private NoticeService noticeService;

  /**
   * 新增数据
   *
   * @param notice 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<Notice> create(@ApiParam(name = "notice", value = "公告表") @RequestBody Notice notice) {
    try {
      Notice result = this.noticeService.create(notice);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param notice 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<Notice> update(@ApiParam(name = "notice", value = "公告表") @RequestBody Notice notice) {
    try {
      Notice result = this.noticeService.update(notice);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   * 因为网关还没有修复patch转post
   *
   * @param notice 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PostMapping("updateTurnPatch")
  public Result<Notice> updateTurnPatch(@ApiParam(name = "notice", value = "公告表") @RequestBody Notice notice) {
    return this.update(notice);
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.noticeService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.noticeService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.noticeService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更改置顶状态（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PostMapping("updateNoticeTopByIds")
  @ApiOperation(value = "更改置顶状态（单个或者批量）")
  public Result<?> updateNoticeTopByIds(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.noticeService.updateNoticeTopByIds(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更改发布状态（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PostMapping("updatePublishByIds")
  @ApiOperation(value = "更改发布状态（单个或者批量）")
  public Result<?> updatePublishByIds(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.noticeService.updatePublishByIds(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
