package com.biz.crm.sfa.business.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 评论点赞记录实体类
 *
 * @author 宋金根
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeCommentLikeRecord", description = "评论点赞记录实体类")
@Entity
@TableName("sfa_notice_comment_like_record")
@Table(name = "sfa_notice_comment_like_record", indexes = {
    @Index(name = "sfa_notice_comment_like_record_index1", columnList = "comment_id,user_name", unique = true),
    @Index(name = "sfa_notice_comment_like_record_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_notice_comment_like_record", comment = "评论点赞记录表")
public class NoticeCommentLikeRecord extends TenantOpEntity {


  private static final long serialVersionUID = 7343455128330164869L;
  /**
   * 评论id
   */
  @ApiModelProperty("评论id")
  @Column(name = "comment_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '评论id'")
  private String commentId;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '用户账号'")
  private String userName;
}
