package com.biz.crm.sfa.business.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 公告范围实体类
 *
 * @author songjingen
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeScope", description = "公告范围实体类")
@Entity
@TableName("sfa_notice_scope")
@Table(name = "sfa_notice_scope", indexes = {
    @Index(name = "sfa_notice_scope_index1", columnList = "notice_id"),
    @Index(name = "sfa_notice_scope_index2", columnList = "tenant_code"),
    @Index(name = "sfa_notice_scope_index3", columnList = "scope_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_notice_scope", comment = "公告范围表")
public class NoticeScope extends TenantEntity {

  private static final long serialVersionUID = 472450903966651456L;
  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  @Column(name = "notice_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '公告id'")
  private String noticeId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  @Column(name = "scope_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '范围编码'")
  private String scopeCode;

  /**
   * 范围名称
   */
  @ApiModelProperty("范围名称")
  @Column(name = "scope_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '范围名称'")
  private String scopeName;

  /**
   * 范围类型(org:组织范围,role:角色范围)
   */
  @ApiModelProperty("范围类型(org:组织范围,role:角色范围)")
  @Column(name = "scope_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '范围类型(org:组织范围,role:角色范围)'")
  private String scopeType;
}
