package com.biz.crm.sfa.business.notice.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import org.apache.ibatis.annotations.Param;

/**
 * 公告评论表(NoticeComment)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-05-27 15:16:54
 */
public interface NoticeCommentMapper extends BaseMapper<NoticeComment> {

  /**
   * 根据公告id分页查询所有数据
   *
   * @param page     分页对象
   * @param noticeId 公告id
   * @return 所有数据
   */
  Page<NoticeComment> findPageByNoticeId(@Param("page") Page<NoticeComment> page, @Param("noticeId") String noticeId);
}

