package com.biz.crm.sfa.business.notice.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.mapper.NoticeCommentMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告评论表(NoticeComment)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-27 15:16:53
 */
@Component
public class NoticeCommentRepository extends ServiceImpl<NoticeCommentMapper, NoticeComment> {

  @Autowired
  private NoticeCommentMapper noticeCommentMapper;

  /**
   * 根据公告id分页查询数据
   *
   * @param pageable 分页对象
   * @param noticeId 实体对象
   * @return
   */
  public Page<NoticeComment> findPageByNoticeId(Pageable pageable, String noticeId) {
    Page<NoticeComment> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<NoticeComment> pageList = this.noticeCommentMapper.findPageByNoticeId(page, noticeId);
    return pageList;
  }

  /**
   * 根据id集合查询数据
   *
   * @param ids
   * @return
   */
  public List<NoticeComment> findByIds(List<String> ids) {
    return this.lambdaQuery().in(NoticeComment::getId, ids).list();
  }
}

