package com.biz.crm.sfa.business.notice.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import org.springframework.data.domain.Pageable;

/**
 * 评论点赞记录表(NoticeCommentLikeRecord)表服务接口
 *
 * @author songjingen
 * @since 2022-06-01 10:22:49
 */
public interface NoticeCommentLikeRecordService {

  /**
   * 分页查询数据
   *
   * @param pageable                分页对象
   * @param noticeCommentLikeRecord 实体对象
   * @return
   */
  Page<NoticeCommentLikeRecord> findByConditions(Pageable pageable, NoticeCommentLikeRecord noticeCommentLikeRecord);

  /**
   * 移动端-根据当前用户点赞
   *
   * @param commentId 实体对象
   * @return 新增结果
   */
  NoticeCommentLikeRecord createByCommentIdAndCurrentUser(String commentId);

  /**
   * 根据当前用户删除数据
   *
   * @param commentId
   */
  void deleteByCurrentUser(String commentId);

}

