package com.biz.crm.sfa.business.notice.local.service;


import com.biz.crm.sfa.business.notice.local.entity.Notice;

import java.util.List;

/**
 * 公告表(Notice)表服务接口
 *
 * @author songjingen
 * @since 2022-05-27 14:17:38
 */
public interface NoticeService {

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  Notice findById(String id);

  /**
   * 新增数据
   *
   * @param notice 实体对象
   * @return 新增结果
   */
  Notice create(Notice notice);

  /**
   * 修改新据
   *
   * @param notice 实体对象
   * @return 修改结果
   */
  Notice update(Notice notice);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

  /**
   * 更改置顶状态
   *
   * @param ids
   */
  void updateNoticeTopByIds(List<String> ids);

  /**
   * 更改发布状态
   *
   * @param ids
   */
  void updatePublishByIds(List<String> ids);
}

