package com.biz.crm.sfa.business.notice.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentLikeRecordRepository;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeCommentLikeRecordService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 评论点赞记录表(NoticeCommentLikeRecord)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-01 10:22:49
 */
@Service("noticeCommentLikeRecordService")
public class NoticeCommentLikeRecordServiceImpl implements NoticeCommentLikeRecordService {

  @Autowired
  private NoticeCommentLikeRecordRepository noticeCommentLikeRecordRepository;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private NoticeCommentRepository noticeCommentRepository;


  /**
   * 分页查询数据
   *
   * @param pageable                分页对象
   * @param noticeCommentLikeRecord 实体对象
   * @return
   */
  @Override
  public Page<NoticeCommentLikeRecord> findByConditions(Pageable pageable, NoticeCommentLikeRecord noticeCommentLikeRecord) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(noticeCommentLikeRecord)) {
      noticeCommentLikeRecord = new NoticeCommentLikeRecord();
    }
    return this.noticeCommentLikeRecordRepository.findByConditions(pageable, noticeCommentLikeRecord);
  }

  @Transactional
  @Override
  public NoticeCommentLikeRecord createByCommentIdAndCurrentUser(String commentId) {
    NoticeCommentLikeRecord noticeCommentLikeRecord = new NoticeCommentLikeRecord();
    noticeCommentLikeRecord.setCommentId(commentId);
    this.createValidate(noticeCommentLikeRecord);
    this.noticeCommentLikeRecordRepository.saveOrUpdate(noticeCommentLikeRecord);
    return noticeCommentLikeRecord;
  }

  @Override
  public void deleteByCurrentUser(String commentId) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    String userName = loginDetails.getAccount();
    NoticeCommentLikeRecord noticeCommentLikeRecord = this.noticeCommentLikeRecordRepository.findByUserNameAndCommentId(userName, commentId);
    Validate.notNull(noticeCommentLikeRecord, "您当前未点赞！");
    this.noticeCommentLikeRecordRepository.deleteByUserName(userName);
  }

  /**
   * 创建验证
   *
   * @param noticeCommentLikeRecord
   */
  private void createValidate(NoticeCommentLikeRecord noticeCommentLikeRecord) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    String account = loginDetails.getAccount();
    Validate.notNull(noticeCommentLikeRecord, "新增时，对象信息不能为空！");
    noticeCommentLikeRecord.setId(null);
    noticeCommentLikeRecord.setUserName(account);
    noticeCommentLikeRecord.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(noticeCommentLikeRecord.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(noticeCommentLikeRecord.getCommentId(), "新增数据时，评论id不能为空！");
    Validate.notBlank(noticeCommentLikeRecord.getUserName(), "新增数据时，用户账号不能为空！");
    List<NoticeComment> noticeComments = this.noticeCommentRepository.findByIds(Lists.newArrayList(noticeCommentLikeRecord.getCommentId()));
    Validate.isTrue(!CollectionUtils.isEmpty(noticeComments), "点赞时，未查询到评论信息！");
    NoticeCommentLikeRecord commentLikeRecord = this.noticeCommentLikeRecordRepository.findByUserNameAndCommentId(account, noticeCommentLikeRecord.getCommentId());
    Validate.isTrue(commentLikeRecord == null, "您已点赞！");
  }
}

