package com.biz.crm.sfa.business.notice.local.service.internal;


import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentRepository;
import com.biz.crm.sfa.business.notice.local.repository.NoticeRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeCommentService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 公告评论表(NoticeComment)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-27 15:16:52
 */
@Service("noticeCommentService")
public class NoticeCommentServiceImpl implements NoticeCommentService {

  @Autowired
  private NoticeCommentRepository noticeCommentRepository;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private NoticeRepository noticeRepository;

  /**
   * 新增数据
   *
   * @param noticeComment 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public NoticeComment create(NoticeComment noticeComment) {
    this.createValidate(noticeComment);
    this.noticeCommentRepository.saveOrUpdate(noticeComment);
    return noticeComment;
  }

  @Override
  public void updateVisibleStateByIds(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "更改可见状态时，主键集合不能为空！");
    List<NoticeComment> list = this.noticeCommentRepository.findByIds(ids);
    Validate.isTrue(!CollectionUtils.isEmpty(list), "更改可见状态时，未查询到数据！");
    list.stream().forEach(noticeComment -> {
      Boolean visibleState = noticeComment.getVisibleState();
      if (visibleState) {
        noticeComment.setVisibleState(false);
      } else {
        noticeComment.setVisibleState(true);
      }
    });
    this.noticeCommentRepository.updateBatchById(list);
  }

  /**
   * 创建验证
   *
   * @param noticeComment
   */
  private void createValidate(NoticeComment noticeComment) {
    Validate.notNull(noticeComment, "新增时，对象信息不能为空！");
    noticeComment.setId(null);
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    noticeComment.setUserName(loginDetails.getAccount());
    noticeComment.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(noticeComment.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(noticeComment.getNoticeId(), "新增数据时，公告id不能为空！");
    Validate.notBlank(noticeComment.getUserName(), "新增数据时，评论人员账号不能为空！");
    //验证当前公告是否允许评论
    Notice notice = this.noticeRepository.getById(noticeComment.getNoticeId());
    Validate.notNull(notice, "新增时，未查询到公告信息！");
    Validate.isTrue(notice.getAllowComment(), "当前公告不允许评论！");
  }
}

