package com.biz.crm.sfa.business.notice.local.service.internal;


import com.biz.crm.sfa.business.notice.local.entity.NoticeFile;
import com.biz.crm.sfa.business.notice.local.repository.NoticeFileRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeFileService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 公告文件表(NoticeFile)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-27 14:17:59
 */
@Service("noticeFileService")
public class NoticeFileServiceImpl implements NoticeFileService {

  @Autowired
  private NoticeFileRepository noticeFileRepository;

  @Transactional
  @Override
  public void createBatch(List<NoticeFile> fileList) {
    Validate.isTrue(!CollectionUtils.isEmpty(fileList), "批量新增文件数据时，入参集合不能为空！");
    fileList.forEach(this::createValidate);
    this.noticeFileRepository.saveBatch(fileList);
  }

  @Transactional
  @Override
  public void deleteByNoticeIds(List<String> noticeIds) {
    this.noticeFileRepository.deleteByNoticeIds(noticeIds);
  }

  /**
   * 创建验证
   *
   * @param noticeFile
   */
  private void createValidate(NoticeFile noticeFile) {
    Validate.notNull(noticeFile, "新增时，对象信息不能为空！");
    noticeFile.setId(null);
    noticeFile.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(noticeFile.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(noticeFile.getFileCode(), "新增数据时，文件路径不能为空！");
    Validate.notBlank(noticeFile.getNoticeId(), "新增数据时，公告id不能为空！");

  }

}

