package com.biz.crm.sfa.business.notice.local.service.internal;


import com.biz.crm.sfa.business.notice.local.entity.NoticeScope;
import com.biz.crm.sfa.business.notice.local.repository.NoticeScopeRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeScopeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 公告范围表(NoticeScope)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-27 14:17:59
 */
@Service("noticeScopeService")
public class NoticeScopeServiceImpl implements NoticeScopeService {

  @Autowired
  private NoticeScopeRepository noticeScopeRepository;

  @Transactional
  @Override
  public void createBatch(List<NoticeScope> scopeList) {
    Validate.isTrue(!CollectionUtils.isEmpty(scopeList), "批量新增发布范围时，入参集合不能为空！");
    scopeList.forEach(this::createValidate);
    this.noticeScopeRepository.saveBatch(scopeList);
  }

  @Transactional
  @Override
  public void deleteByNoticeIds(List<String> noticeIds) {
    this.noticeScopeRepository.deleteByNoticeIds(noticeIds);
  }

  /**
   * 创建验证
   *
   * @param noticeScope
   */
  private void createValidate(NoticeScope noticeScope) {
    Validate.notNull(noticeScope, "新增时，对象信息不能为空！");
    noticeScope.setId(null);
    noticeScope.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(noticeScope.getTenantCode(), "新增数据时，租户编号不能为空！");

  }

}

