/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import com.biz.crm.sfa.business.notice.sdk.service.NoticeVoService;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/notice/noticeVo"})
@Api(tags={"\u516c\u544a\u7ba1\u7406\uff1aNoticeVo\uff1a\u516c\u544avo"})
public class NoticeVoController {
    private static final Logger log = LoggerFactory.getLogger(NoticeVoController.class);
    @Autowired
    private NoticeVoService noticeVoService;
    @Autowired
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<NoticeVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u516c\u544a\u6761\u4ef6dto") NoticePageDto dto) {
        try {
            Page page = this.noticeVoService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<NoticeVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            NoticeVo notice = this.noticeVoService.findById(id);
            return Result.ok((Object)notice);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef-\u5206\u9875\u67e5\u8be2\uff08\u5728\u5f53\u524d\u7528\u6237\u8303\u56f4\u4e14\u5df2\u53d1\u5e03\uff09\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByCurrentUserAndNoticePageDto"})
    public Result<Page<NoticeVo>> findByCurrentUserAndNoticePageDto(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u516c\u544a\u6761\u4ef6dto") NoticePageDto dto) {
        try {
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            Object[] roles = loginDetails.getRoleCodes();
            if (roles != null && !roles.equals("ADMIN")) {
                dto.setQueryFlag("H5");
                dto.setPublish(Boolean.valueOf(true));
                dto.setRoles((List)Lists.newArrayList((Object[])roles));
                dto.setOrgCode(loginDetails.getOrgCode());
                dto.setNowDate(new Date());
            }
            Page page = this.noticeVoService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef-\u67e5\u8be2\u6700\u65b0\u7684\u516c\u544a\uff08\u5728\u5f53\u524d\u7528\u6237\u8303\u56f4\u4e14\u5df2\u53d1\u5e03\uff09\u6570\u636e")
    @GetMapping(value={"findLatestByCurrentUser"})
    public Result<NoticeVo> findLatestByCurrentUser() {
        try {
            return Result.ok((Object)this.noticeVoService.findLatestByCurrentUser());
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef-\u67e5\u8be2\u516c\u544a\u8be6\u60c5\u7ffb\u9875\uff08\u5728\u5f53\u524d\u7528\u6237\u8303\u56f4\u4e14\u5df2\u53d1\u5e03\uff09\u6570\u636e")
    @GetMapping(value={"findByIdAndTurnFlag"})
    public Result<NoticeVo> findByIdAndTurnFlag(@ApiParam(name="turnFlag", value="\u7ffb\u9875\u6807\u8bb0\uff1aup-\u4e0a\u4e00\u9875\uff0cdown-\u4e0b\u4e00\u9875") @RequestParam(value="turnFlag") String turnFlag, @ApiParam(name="id", value="\u4e3b\u952eid") @RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.noticeVoService.findByIdAndTurnFlag(turnFlag, id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

