/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentRepository;
import com.biz.crm.sfa.business.notice.local.repository.NoticeRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeCommentService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeCommentService")
public class NoticeCommentServiceImpl
implements NoticeCommentService {
    @Autowired
    private NoticeCommentRepository noticeCommentRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NoticeRepository noticeRepository;

    @Override
    @Transactional
    public NoticeComment create(NoticeComment noticeComment) {
        this.createValidate(noticeComment);
        this.noticeCommentRepository.saveOrUpdate((Object)noticeComment);
        return noticeComment;
    }

    @Override
    public void updateVisibleStateByIds(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u66f4\u6539\u53ef\u89c1\u72b6\u6001\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<NoticeComment> list = this.noticeCommentRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u66f4\u6539\u53ef\u89c1\u72b6\u6001\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        list.stream().forEach(noticeComment -> {
            Boolean visibleState = noticeComment.getVisibleState();
            if (visibleState.booleanValue()) {
                noticeComment.setVisibleState(false);
            } else {
                noticeComment.setVisibleState(true);
            }
        });
        this.noticeCommentRepository.updateBatchById(list);
    }

    private void createValidate(NoticeComment noticeComment) {
        Validate.notNull((Object)((Object)noticeComment), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        noticeComment.setId(null);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        noticeComment.setUserName(loginDetails.getAccount());
        noticeComment.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)noticeComment.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)noticeComment.getNoticeId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u516c\u544aid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)noticeComment.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8bc4\u8bba\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Notice notice = (Notice)((Object)this.noticeRepository.getById((Serializable)((Object)noticeComment.getNoticeId())));
        Validate.notNull((Object)((Object)notice), (String)"\u65b0\u589e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u516c\u544a\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)notice.getAllowComment(), (String)"\u5f53\u524d\u516c\u544a\u4e0d\u5141\u8bb8\u8bc4\u8bba\uff01", (Object[])new Object[0]);
    }
}

