/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentLikeRecordRepository;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentRepository;
import com.biz.crm.sfa.business.notice.sdk.service.NoticeCommentVoService;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeCommentVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NoticeCommentVoServiceImpl
implements NoticeCommentVoService {
    @Autowired
    private NoticeCommentRepository noticeCommentRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NoticeCommentLikeRecordRepository noticeCommentLikeRecordRepository;
    @Autowired
    private LoginUserService loginUserService;

    public Page<NoticeCommentVo> findPageByNoticeId(Pageable pageable, String noticeId) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isBlank((CharSequence)noticeId)) {
            return new Page();
        }
        Page<NoticeComment> page = this.noticeCommentRepository.findPageByNoticeId(pageable, noticeId);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        Page voPage = new Page();
        BeanUtils.copyProperties(page, (Object)voPage);
        voPage.setRecords(this.convertToNoticeCommentVo(records));
        return voPage;
    }

    private List<NoticeCommentVo> convertToNoticeCommentVo(List<NoticeComment> records) {
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String account = loginDetails.getAccount();
        List userNames = records.stream().map(NoticeComment::getUserName).collect(Collectors.toList());
        List<String> commentIds = records.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List byUserNames = this.userFeignVoService.findByUserNames(userNames);
        List<NoticeCommentLikeRecord> commentLikeRecords = this.noticeCommentLikeRecordRepository.findByCommentIds(commentIds);
        Map<Object, Object> userMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)byUserNames)) {
            userMap = byUserNames.stream().collect(Collectors.toMap(UserVo::getUserName, o -> o));
        }
        Map<Object, Object> likeMap = new HashMap();
        Map<Object, Object> userNameLikeMap = new HashMap();
        if (!CollectionUtils.isEmpty(commentLikeRecords)) {
            likeMap = commentLikeRecords.stream().collect(Collectors.groupingBy(NoticeCommentLikeRecord::getCommentId, Collectors.counting()));
            userNameLikeMap = commentLikeRecords.stream().collect(Collectors.groupingBy(NoticeCommentLikeRecord::getCommentId, Collectors.mapping(NoticeCommentLikeRecord::getUserName, Collectors.toList())));
        }
        ArrayList<NoticeCommentVo> noticeCommentVos = new ArrayList<NoticeCommentVo>();
        for (NoticeComment noticeComment : records) {
            List userNameLikes;
            Long count;
            NoticeCommentVo noticeCommentVo = (NoticeCommentVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)noticeComment, NoticeCommentVo.class, HashSet.class, ArrayList.class, new String[0]);
            UserVo userVo = (UserVo)userMap.get(noticeCommentVo.getUserName());
            if (userVo != null) {
                BeanUtils.copyProperties((Object)userVo, (Object)noticeCommentVo, (String[])new String[]{"id", "tenantCode"});
            }
            if ((count = (Long)likeMap.get(noticeComment.getId())) != null) {
                noticeCommentVo.setLikeCount(Integer.valueOf(count.intValue()));
            }
            if (!CollectionUtils.isEmpty((Collection)(userNameLikes = (List)userNameLikeMap.get(noticeComment.getId()))) && userNameLikes.contains(account)) {
                noticeCommentVo.setCurrentLikeStatus(Boolean.valueOf(true));
            } else {
                noticeCommentVo.setCurrentLikeStatus(Boolean.valueOf(false));
            }
            noticeCommentVos.add(noticeCommentVo);
        }
        return noticeCommentVos;
    }
}

