/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.entity.NoticeFile;
import com.biz.crm.sfa.business.notice.local.entity.NoticeScope;
import com.biz.crm.sfa.business.notice.local.repository.NoticeRepository;
import com.biz.crm.sfa.business.notice.local.service.NoticeFileService;
import com.biz.crm.sfa.business.notice.local.service.NoticeScopeService;
import com.biz.crm.sfa.business.notice.local.service.NoticeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeService")
public class NoticeServiceImpl
implements NoticeService {
    @Autowired
    private NoticeRepository noticeRepository;
    @Autowired
    private NoticeFileService noticeFileService;
    @Autowired
    private NoticeScopeService noticeScopeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Notice findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (Notice)((Object)this.noticeRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public Notice create(Notice notice) {
        this.createValidate(notice);
        this.noticeRepository.saveOrUpdate((Object)notice);
        List<NoticeFile> fileList = notice.getFileList();
        if (!CollectionUtils.isEmpty(fileList)) {
            fileList.stream().forEach(noticeFile -> noticeFile.setNoticeId(notice.getId()));
            this.noticeFileService.createBatch(fileList);
        }
        List<NoticeScope> scopeList = notice.getScopeList();
        scopeList.stream().forEach(noticeScope -> noticeScope.setNoticeId(notice.getId()));
        this.noticeScopeService.createBatch(scopeList);
        return notice;
    }

    @Override
    @Transactional
    public Notice update(Notice notice) {
        Validate.notNull((Object)((Object)notice), (String)"\u7f16\u8f91\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String id = notice.getId();
        Validate.notBlank((CharSequence)id, (String)"\u7f16\u8f91\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Notice oldNotice = (Notice)((Object)this.noticeRepository.getById((Serializable)((Object)notice)));
        Validate.notNull((Object)((Object)oldNotice), (String)"\u7f16\u8f91\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)notice), (Object)((Object)oldNotice), (String[])new String[]{"id", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime", "createName"});
        this.updateValidate(oldNotice);
        this.noticeRepository.saveOrUpdate((Object)notice);
        ArrayList noticeIds = Lists.newArrayList((Object[])new String[]{id});
        this.noticeFileService.deleteByNoticeIds(noticeIds);
        List<NoticeFile> fileList = notice.getFileList();
        if (!CollectionUtils.isEmpty(fileList)) {
            fileList.stream().forEach(noticeFile -> noticeFile.setNoticeId(id));
            this.noticeFileService.createBatch(fileList);
        }
        this.noticeScopeService.deleteByNoticeIds(noticeIds);
        List<NoticeScope> scopeList = notice.getScopeList();
        scopeList.stream().forEach(noticeScope -> noticeScope.setNoticeId(id));
        this.noticeScopeService.createBatch(scopeList);
        return notice;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.noticeRepository.updateDelFlagByIds(idList, DelFlagStatusEnum.DELETE);
        this.noticeFileService.deleteByNoticeIds(idList);
        this.noticeScopeService.deleteByNoticeIds(idList);
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.noticeRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.noticeRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    @Override
    public void updateNoticeTopByIds(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u6279\u91cf\u66f4\u6539\u7f6e\u9876\u72b6\u6001\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Notice> notices = this.noticeRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(notices) ? 1 : 0) != 0, (String)"\u6279\u91cf\u66f4\u6539\u7f6e\u9876\u72b6\u6001\u65f6\uff0c\u4e3a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        notices.stream().forEach(notice -> {
            Boolean noticeTop = notice.getNoticeTop();
            if (noticeTop.booleanValue()) {
                notice.setNoticeTop(false);
            } else {
                notice.setNoticeTop(true);
            }
        });
        this.noticeRepository.updateBatchById(notices);
    }

    @Override
    public void updatePublishByIds(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u6279\u91cf\u66f4\u6539\u53d1\u5e03\u72b6\u6001\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Notice> notices = this.noticeRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(notices) ? 1 : 0) != 0, (String)"\u6279\u91cf\u66f4\u6539\u53d1\u5e03\u72b6\u6001\u65f6\uff0c\u4e3a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        notices.stream().forEach(notice -> {
            Boolean publish = notice.getPublish();
            if (publish.booleanValue()) {
                notice.setPublish(false);
            } else {
                notice.setPublish(true);
            }
        });
        this.noticeRepository.updateBatchById(notices);
    }

    private void createValidate(Notice notice) {
        Validate.notNull((Object)((Object)notice), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        notice.setId(null);
        notice.setTenantCode(TenantUtils.getTenantCode());
        notice.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        notice.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        notice.setAllowComment(false);
        Validate.notBlank((CharSequence)notice.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)notice.getAllowComment(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u5141\u8bb8\u8bc4\u8bba\uff0ctrue-\u662f\uff0cfalse-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)notice.getPublish(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u53d1\u5e03\uff0ctrue-\u662f\uff0cfalse-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notice.getTitle(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)notice.getNoticeTop(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u7f6e\u9876\uff0ctrue-\u662f\uff0cfalse-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notice.getNoticeType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        notice.setPublishOrgCode(loginDetails.getOrgCode());
        notice.setPublishOrgName(loginDetails.getOrgName());
    }

    private void updateValidate(Notice notice) {
        notice.setAllowComment(false);
        Validate.notNull((Object)((Object)notice), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notice.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notice.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)notice.getAllowComment(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u662f\u5426\u5141\u8bb8\u8bc4\u8bba\uff0ctrue-\u662f\uff0cfalse-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)notice.getPublish(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u662f\u5426\u53d1\u5e03\uff0ctrue-\u662f\uff0cfalse-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notice.getTitle(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)notice.getNoticeTop(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u662f\u5426\u7f6e\u9876\uff0ctrue-\u662f\uff0cfalse-\u5426\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)notice.getNoticeType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        notice.setPublishOrgCode(loginDetails.getOrgCode());
        notice.setPublishOrgName(loginDetails.getOrgName());
    }
}

