/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.repository.NoticeRepository;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import com.biz.crm.sfa.business.notice.sdk.service.NoticeVoService;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="noticeVoService")
public class NoticeVoServiceImpl
implements NoticeVoService {
    @Autowired
    private NoticeRepository noticeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;

    public Page<NoticeVo> findByConditions(Pageable pageable, NoticePageDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new NoticePageDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<Notice> page = this.noticeRepository.findByConditions(pageable, dto);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        List noticeVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)records, Notice.class, NoticeVo.class, HashSet.class, ArrayList.class, new String[]{"fileList", "scopeList"});
        Page voPage = new Page();
        BeanUtils.copyProperties(page, (Object)voPage);
        voPage.setRecords(noticeVos);
        return voPage;
    }

    public NoticeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Notice detailsById = this.noticeRepository.findDetailsById(id);
        if (detailsById == null) {
            return null;
        }
        return (NoticeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailsById, NoticeVo.class, HashSet.class, ArrayList.class, new String[]{"fileList", "scopeList"});
    }

    public NoticeVo findLatestByCurrentUser() {
        Page page = new Page(0L, 1L);
        NoticePageDto dto = this.getCurrentUserDto();
        Page<Notice> conditions = this.noticeRepository.findByConditions((Page<Notice>)page, dto);
        List records = conditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return null;
        }
        return (NoticeVo)this.nebulaToolkitService.copyObjectByWhiteList(records.get(0), NoticeVo.class, HashSet.class, ArrayList.class, new String[]{"fileList", "scopeList"});
    }

    public NoticeVo findByIdAndTurnFlag(String turnFlag, String id) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{turnFlag, id})) {
            return null;
        }
        Notice notice = (Notice)((Object)this.noticeRepository.getById((Serializable)((Object)id)));
        if (notice == null) {
            return null;
        }
        NoticePageDto dto = this.getCurrentUserDto();
        dto.setTurnFlag(turnFlag);
        Date createTime = notice.getCreateTime();
        if ("up".equals(turnFlag)) {
            dto.setCreateTimeEnd(createTime);
        } else if ("down".equals(turnFlag)) {
            dto.setCreateTimeStart(createTime);
        } else {
            return null;
        }
        Page page = new Page(0L, 1L);
        Page<Notice> conditions = this.noticeRepository.findByConditions((Page<Notice>)page, dto);
        List records = conditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return null;
        }
        return (NoticeVo)this.nebulaToolkitService.copyObjectByWhiteList(records.get(0), NoticeVo.class, HashSet.class, ArrayList.class, new String[]{"fileList", "scopeList"});
    }

    private NoticePageDto getCurrentUserDto() {
        NoticePageDto dto = new NoticePageDto();
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        Object[] roles = loginDetails.getRoleCodes();
        if (roles != null && !roles.equals("ADMIN")) {
            dto.setQueryFlag("H5");
            dto.setPublish(Boolean.valueOf(true));
            dto.setOrgCode(loginDetails.getOrgCode());
            dto.setRoles((List)Lists.newArrayList((Object[])roles));
            dto.setNowDate(new Date());
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }
}

