package com.biz.crm.sfa.business.notice.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 公告分页dto
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticePageDto", description = "公告分页dto")
public class NoticePageDto implements Serializable {

  private static final long serialVersionUID = -5631908685787377055L;

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  private String title;

  /**
   * 类型
   */
  @ApiModelProperty("类型")
  private String noticeType;

  /**
   * 发布部门code
   */
  @ApiModelProperty("发布部门code")
  private String publishOrgCode;

  /**
   * 发布部门名称
   */
  @ApiModelProperty("发布部门名称")
  private String publishOrgName;

  /**
   * 是否发布
   */
  @ApiModelProperty(value = "是否发布")
  private Boolean publish;

  /**
   * 组织编码
   */
  @ApiModelProperty(value = "组织编码")
  private String orgCode;

  /**
   * 角色范围编码集合
   */
  @ApiModelProperty("角色范围编码集合")
  private List<String> roles;

  /**
   * 查询标记
   *
   * @see com.biz.crm.business.common.sdk.constant.CommonConstant
   */
  @ApiModelProperty(value = "查询标记", hidden = true)
  private String queryFlag;

  /**
   * 创建时间-开始
   */
  @ApiModelProperty(name = "createTime", value = "创建时间-开始")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  /**
   * 创建时间-结束
   */
  @ApiModelProperty(name = "createTime", value = "创建时间-结束")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * 翻页标记
   */
  @ApiModelProperty(value = "翻页标记", hidden = true)
  private String turnFlag;

  @ApiModelProperty(value = "当前时间", hidden = true)
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date nowDate;
}
