package com.biz.crm.sfa.business.notice.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeVo;
import org.springframework.data.domain.Pageable;

/**
 * 公告表(NoticeVO)表服务接口
 *
 * @author songjingen
 * @since 2022-05-27 14:17:38
 */
public interface NoticeVoService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      分页条件
   * @return
   */
  Page<NoticeVo> findByConditions(Pageable pageable, NoticePageDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  NoticeVo findById(String id);

  /**
   * 移动端-查询最新的公告（在当前用户范围且已发布）数据
   *
   * @return 所有数据
   */
  NoticeVo findLatestByCurrentUser();

  /**
   * 移动端-根据id和翻页标记查询（在当前用户范围且已发布）数据
   *
   * @param id
   * @param turnFlag 翻页标记：up-上一页，down-下一页
   * @return 数据
   */
  NoticeVo findByIdAndTurnFlag(String turnFlag, String id);

}

