package com.biz.crm.sfa.business.notice.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;


/**
 * 公告范围vo
 *
 * @author songjingen
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeScopeVo", description = "公告范围vo")
public class NoticeScopeVo extends TenantVo {

  private static final long serialVersionUID = 472450903966651456L;
  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  private String noticeId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围名称
   */
  @ApiModelProperty("范围名称")
  private String scopeName;

  /**
   * 范围类型(org:组织范围,role:角色范围)
   */
  @ApiModelProperty("范围类型(org:组织范围,role:角色范围)")
  private String scopeType;
}
