package com.biz.crm.sfa.business.notice.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Transient;
import java.util.Date;
import java.util.List;


/**
 * 公告vo
 *
 * @author songjingen
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeVo", description = "公告vo")
public class NoticeVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 9014755486223607858L;

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  private String title;

  /**
   * 类型
   */
  @ApiModelProperty("类型")
  private String noticeType;

  /**
   * 是否置顶
   */
  @ApiModelProperty("是否置顶: true-是，false-否")
  private Boolean noticeTop;

  /**
   * 是否发布
   */
  @ApiModelProperty("是否发布: true-是，false-否")
  private Boolean publish;

  /**
   * 是否允许评论
   */
  @ApiModelProperty("是否允许评论: true-是，false-否")
  private Boolean allowComment;

  /**
   * 发布部门code
   */
  @ApiModelProperty("发布部门code")
  private String publishOrgCode;

  /**
   * 发布部门名称
   */
  @ApiModelProperty("发布部门名称")
  private String publishOrgName;

  /**
   * 生效开始时间
   */
  @ApiModelProperty("生效开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date startTime;


  /**
   * 生效结束时间
   */
  @ApiModelProperty("生效结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date endTime;

  /**
   * 公告内容
   */
  @ApiModelProperty("公告内容")
  private String content;

  /**
   * 已读人数
   */
  @ApiModelProperty("公告内容")
  private String readCount;

  /**
   * 公告文件关联信息
   */
  @ApiModelProperty("公告文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<NoticeFileVo> fileList;

  /**
   * 公告范围关联信息
   */
  @ApiModelProperty("公告范围关联信息")
  @Transient
  @TableField(exist = false)
  private List<NoticeScopeVo> scopeList;
}
