package com.biz.crm.sfa.business.notice.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @description: 公告类型枚举
 */
public enum NoticeTypeEnum {

  POLICY("policy", "policy", "政策", "1"),
  ADVISE("advise", "advise", "通知", "2"),
  FILE("file", "file", "文件", "3"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  NoticeTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ClientTypeEnum
   *
   * @param key
   * @return
   */
  public static NoticeTypeEnum getByKey(String key) {
    return Arrays.stream(NoticeTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 ClientTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static NoticeTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(NoticeTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }

}
