package com.biz.crm.sfa.business.notice.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;


/**
 * 公告评论vo
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeCommentVo", description = "公告评论vo")
public class NoticeCommentVo extends TenantVo {


  private static final long serialVersionUID = 9014755486223607858L;
  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  private String noticeId;

  /**
   * 评论人员账号
   */
  @ApiModelProperty("评论人员账号")
  private String userName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 用户头像url
   */
  @ApiModelProperty("用户头像url")
  private String userHeadUrl;

  /**
   * 评论内容
   */
  @ApiModelProperty("评论内容")
  private String content;

  /**
   * 点赞数量
   */
  @ApiModelProperty("点赞数量")
  private Integer likeCount = 0;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 是否可见
   */
  @ApiModelProperty("是否可见")
  private Boolean visibleState;

  /**
   * 当前用户是否点赞评论
   */
  @ApiModelProperty("当前用户是否点赞评论")
  private Boolean currentLikeStatus;


}
