package com.biz.crm.sfa.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 订单表
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderEntity", description = "订单表")
@Entity
@TableName("sfa_order")
@Table(name = "sfa_order", indexes = {
    @Index(name = "sfa_order_index1", columnList = "source_code"),
    @Index(name = "sfa_order_index2", columnList = "source_type"),
    @Index(name = "sfa_order_index3", columnList = "order_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_order", comment = "订单表")
public class OrderEntity extends TenantOpEntity {

  private static final long serialVersionUID = 6377771515705050637L;

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  @Column(name = "order_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单编码'")
  private String orderCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @Column(name = "terminal_code", length = 64,  columnDefinition = "VARCHAR(64) COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @Column(name = "terminal_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '终端名称'")
  private String terminalName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  @Column(name = "post_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人职位编码'")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  @Column(name = "post_name", columnDefinition = "varchar(255) COMMENT '提交人职位名称'")
  private String postName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人组织编码")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人组织编码'")
  private String orgCode;

  /**
   * 提交人组织名称
   */
  @ApiModelProperty("提交人组织名称")
  @Column(name = "org_name", columnDefinition = "varchar(255) COMMENT '提交人组织名称'")
  private String orgName;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  @Column(name = "superior_customer_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '上级客户编码'")
  private String superiorCustomerCode;

  /**
   * 上级客户名称
   */
  @ApiModelProperty("上级客户名称")
  @Column(name = "superior_customer_name", length = 128, columnDefinition = "VARCHAR(64) COMMENT '上级客户名称'")
  private String superiorCustomerName;

  /**
   * 联系人名称
   */
  @ApiModelProperty("联系人名称")
  @Column(name = "contact_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系人名称'")
  private String contactName;

  /**
   * 联系人电话
   */
  @ApiModelProperty("联系人电话")
  @Column(name = "contact_phone", length = 32, columnDefinition = "VARCHAR(32) COMMENT '联系人电话'")
  private String contactPhone;

  /**
   * 收货地址
   */
  @ApiModelProperty("收货地址")
  @Column(name = "delivery_address", columnDefinition = "VARCHAR(255) COMMENT '收货地址'")
  private String deliveryAddress;

  /**
   * 期望到货日期
   */
  @ApiModelProperty("期望到货日期")
  @Column(name = "expect_arrival_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '期望到货日期'")
  private String expectArrivalDate;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "VARCHAR(255) COMMENT '备注'")
  private String remark;

  /**
   * 来源类型
   * @see com.biz.crm.sfa.business.order.sdk.enums.OrderSourceType
   */
  @ApiModelProperty("来源类型")
  @Column(name = "source_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '来源类型'")
  private String sourceType;

  /**
   * 来源业务编码
   */
  @ApiModelProperty("来源业务编码")
  @Column(name = "source_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '来源业务编码'")
  private String sourceCode;

  /**
   * 商品信息
   */
  @ApiModelProperty("商品信息")
  @Transient
  @TableField(exist = false)
  private List<OrderProductEntity> products;
}
