package com.biz.crm.sfa.business.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 订单商品表
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderProductEntity", description = "订单商品表")
@Entity
@TableName("sfa_order_product")
@Table(name = "sfa_order_product", indexes = {
    @Index(name = "sfa_order_product_index1", columnList = "order_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_order_product", comment = "订单商品表")
public class OrderProductEntity extends UuidEntity {


  private static final long serialVersionUID = -5704295948584491847L;

  /**
   * 订单ID
   */
  @ApiModelProperty("订单ID")
  @Column(name = "order_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT 'TPM活动执行订单ID'")
  private String orderId;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '商品名称'")
  private String productName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @Column(name = "product_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '商品编码'")
  private String productCode;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  @Column(name = "quantity", columnDefinition = "decimal(9,2) COMMENT '数量'")
  private BigDecimal quantity;

  /**
   * 价格
   */
  @ApiModelProperty("价格")
  @Column(name = "price", columnDefinition = "decimal(9,2) COMMENT '价格'")
  private BigDecimal price;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  @Column(name = "unite", length = 64, columnDefinition = "varchar(64) COMMENT '销售单位'")
  private String unite;
}
