package com.biz.crm.sfa.business.order.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.mapper.OrderMapper;
import com.biz.crm.sfa.business.order.local.model.OrderConditionModel;
import com.biz.crm.sfa.business.order.sdk.dto.OrderPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 订单表的数据库访问类 {@link OrderEntity}
 *
 * @author ning.zhang
 * @date 2022-07-04 18:49:06
 */
@Component
public class OrderRepository extends ServiceImpl<OrderMapper, OrderEntity> {

  /**
   * 通过订单多条件查询订单信息
   *
   * @param model 订单多条件参数
   * @return 订单信息
   */
  public List<OrderEntity> findByOrderConditionModel(OrderConditionModel model) {
    return this.baseMapper.findByOrderConditionModel(model);
  }

  /**
   * 订单分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OrderEntity> 订单分页信息
   */
  public Page<OrderEntity> findByConditions(Pageable pageable, OrderPageDto dto) {
    Page<OrderEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
