package com.biz.crm.sfa.business.order.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.sdk.dto.OrderPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 订单表服务接口
 *
 * @author ning.zhang
 * @date 2022-07-04 18:49:07
 */
public interface OrderService {

  /**
   * 批量新增数据
   *
   * @param entities 实体对象集合
   * @return 新增结果
   */
  List<OrderEntity> createBatch(List<OrderEntity> entities);

  /**
   * 订单分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OrderEntity> 订单分页信息
   */
  Page<OrderEntity> findByConditions(Pageable pageable, OrderPageDto dto);

  /**
   * 通过订单ID获取订单信息
   *
   * @param id 订单ID
   * @return 订单信息
   */
  OrderEntity findById(String id);
}
