package com.biz.crm.sfa.business.order.local.service.internal;

import com.biz.crm.sfa.business.order.local.entity.OrderProductEntity;
import com.biz.crm.sfa.business.order.local.repository.OrderProductRepository;
import com.biz.crm.sfa.business.order.local.service.OrderProductService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 订单商品表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-04 18:49:08
 */
@Slf4j
@Service("orderProductService")
public class OrderProductServiceImpl implements OrderProductService {

  @Autowired
  private OrderProductRepository orderProductRepository;

  @Override
  @Transactional
  public List<OrderProductEntity> createBatch(List<OrderProductEntity> entities) {
    this.createValidate(entities);
    this.orderProductRepository.saveBatch(entities);
    return entities;
  }

  /**
   * 创建验证
   *
   * @param entities 验证对象
   */
  private void createValidate(List<OrderProductEntity> entities) {
    Validate.notNull(!CollectionUtils.isEmpty(entities), "新增数据时，订单商品对象信息不能为空！");
    entities.forEach(productEntity -> {
      productEntity.setId(null);
      Validate.notBlank(productEntity.getProductCode(), "新增数据时，订单商品编码不能为空！");
      Validate.notBlank(productEntity.getProductName(), "新增数据时，订单商品名称不能为空！");
      Validate.notBlank(productEntity.getUnite(), "新增数据时，订单商品销售单位不能为空！");
      Validate.isTrue(Objects.nonNull(productEntity.getPrice()) && productEntity.getPrice().compareTo(BigDecimal.ZERO) >= 0, "新增数据时，订单商品价格数据错误！");
      Validate.isTrue(Objects.nonNull(productEntity.getQuantity()) && productEntity.getQuantity().compareTo(BigDecimal.ZERO) > 0, "新增数据时，订单商品数量数据错误！");
    });
  }
}
