/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.service.OrderService;
import com.biz.crm.sfa.business.order.sdk.dto.OrderPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/order/order"})
@Api(tags={"\u8ba2\u5355: Order: \u8ba2\u5355\u4fe1\u606f"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u8ba2\u5355\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<OrderEntity>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="OrderPageDto", value="\u5206\u9875Dto") OrderPageDto dto) {
        try {
            return Result.ok(this.orderService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u8ba2\u5355ID\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<OrderEntity> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            return Result.ok((Object)((Object)this.orderService.findById(id)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

