package com.biz.crm.sfa.business.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.service.OrderService;
import com.biz.crm.sfa.business.order.sdk.dto.OrderPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单: Order: 订单信息
 * 
 * @author ning.zhang
 * @date 2022/7/7
 */
@Slf4j
@RestController
@RequestMapping("/v1/order/order")
@Api(tags = "订单: Order: 订单信息")
public class OrderController {

  @Autowired
  private OrderService orderService;

  /**
   * 订单分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 订单分页数据
   */
  @ApiOperation(value = "订单分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<OrderEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "OrderPageDto", value = "分页Dto") OrderPageDto dto) {
    try {
      return Result.ok(this.orderService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过订单ID获取订单信息
   *
   * @param id 订单ID
   * @return 订单信息
   */
  @ApiOperation(value = "通过订单ID获取订单信息")
  @GetMapping("/findById")
  public Result<OrderEntity> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.orderService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
