package com.biz.crm.sfa.business.order.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.model.OrderConditionModel;
import com.biz.crm.sfa.business.order.sdk.dto.OrderPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 订单表的mybatis-plus接口类 {@link OrderEntity}
 *
 * @author ning.zhang
 * @date 2022-07-04 18:49:05
 */
public interface OrderMapper extends BaseMapper<OrderEntity> {

  /**
   * 通过订单多条件查询订单信息
   *
   * @param model 订单多条件参数
   * @return 订单信息
   */
  List<OrderEntity> findByOrderConditionModel(@Param("model") OrderConditionModel model);

  /**
   * 订单分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<OrderEntity> 订单分页信息
   */
  Page<OrderEntity> findByConditions(Page<OrderEntity> page, @Param("dto") OrderPageDto dto);
}

