package com.biz.crm.sfa.business.order.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Set;

/**
 * 订单多条件model
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderConditionModel", description = "订单多条件model")
public class OrderConditionModel {

  /**
   * 来源类型
   * @see com.biz.crm.sfa.business.order.sdk.enums.OrderSourceType
   */
  @ApiModelProperty("来源类型")
  private String sourceType;

  /**
   * 来源业务编码
   */
  @ApiModelProperty(value = "来源业务编码")
  private Set<String> sourceCodes;

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 订单ID集合
   */
  @ApiModelProperty("订单ID集合")
  private Set<String> orderIds;
}
