/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.order.local.service.internal;

import com.biz.crm.sfa.business.order.local.entity.OrderProductEntity;
import com.biz.crm.sfa.business.order.local.repository.OrderProductRepository;
import com.biz.crm.sfa.business.order.local.service.OrderProductService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderProductService")
public class OrderProductServiceImpl
implements OrderProductService {
    private static final Logger log = LoggerFactory.getLogger(OrderProductServiceImpl.class);
    @Autowired
    private OrderProductRepository orderProductRepository;

    @Override
    @Transactional
    public List<OrderProductEntity> createBatch(List<OrderProductEntity> entities) {
        this.createValidate(entities);
        this.orderProductRepository.saveBatch(entities);
        return entities;
    }

    private void createValidate(List<OrderProductEntity> entities) {
        Validate.notNull((Object)(!CollectionUtils.isEmpty(entities) ? 1 : 0), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entities.forEach(productEntity -> {
            productEntity.setId(null);
            Validate.notBlank((CharSequence)productEntity.getProductCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)productEntity.getProductName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)productEntity.getUnite(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u9500\u552e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(productEntity.getPrice()) && productEntity.getPrice().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u4ef7\u683c\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(productEntity.getQuantity()) && productEntity.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
        });
    }
}

