/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.entity.OrderProductEntity;
import com.biz.crm.sfa.business.order.local.model.OrderConditionModel;
import com.biz.crm.sfa.business.order.local.repository.OrderRepository;
import com.biz.crm.sfa.business.order.local.service.OrderProductService;
import com.biz.crm.sfa.business.order.local.service.OrderService;
import com.biz.crm.sfa.business.order.sdk.dto.OrderPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderService")
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderRepository orderRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private OrderProductService orderProductService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public List<OrderEntity> createBatch(List<OrderEntity> entities) {
        this.createValidate(entities);
        this.orderRepository.saveBatch(entities);
        List<OrderProductEntity> productEntities = entities.stream().flatMap(orderEntity -> orderEntity.getProducts().stream().map(productEntity -> {
            productEntity.setOrderId(orderEntity.getId());
            return productEntity;
        })).collect(Collectors.toList());
        this.orderProductService.createBatch(productEntities);
        return entities;
    }

    @Override
    public Page<OrderEntity> findByConditions(Pageable pageable, OrderPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (OrderPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new OrderPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.orderRepository.findByConditions(pageable, dto);
    }

    @Override
    public OrderEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        OrderConditionModel model = new OrderConditionModel();
        model.setOrderIds(Sets.newHashSet((Object[])new String[]{id}));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<OrderEntity> orderEntities = this.orderRepository.findByOrderConditionModel(model);
        if (CollectionUtils.isEmpty(orderEntities)) {
            return null;
        }
        return orderEntities.get(0);
    }

    private void createValidate(List<OrderEntity> entities) {
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        entities.forEach(orderEntity -> {
            orderEntity.setId(null);
            orderEntity.setPostCode(loginDetails.getPostCode());
            orderEntity.setPostName(loginDetails.getPostName());
            orderEntity.setOrgCode(loginDetails.getOrgCode());
            orderEntity.setOrgName(loginDetails.getOrgName());
            orderEntity.setOrderCode((String)this.generateCodeService.generateCode("SOR", 1).get(0));
            Validate.notBlank((CharSequence)orderEntity.getSuperiorCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getSuperiorCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u4e0a\u7ea7\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getContactName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getContactPhone(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getDeliveryAddress(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getExpectArrivalDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u671f\u671b\u5230\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getSourceType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getSourceCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u6765\u6e90\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getTerminalCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)orderEntity.getTerminalName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)orderEntity.getExpectArrivalDate()), (String)"\u975e\u6cd5\u7684\u671f\u671b\u5230\u8d27\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(orderEntity.getProducts()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }
}

