/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.order.local.service.register;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.order.local.entity.OrderEntity;
import com.biz.crm.sfa.business.order.local.model.OrderConditionModel;
import com.biz.crm.sfa.business.order.local.repository.OrderRepository;
import com.biz.crm.sfa.business.order.local.service.OrderService;
import com.biz.crm.sfa.business.order.sdk.enums.OrderSourceType;
import com.biz.crm.sfa.business.template.action.tpm.sdk.register.ActionTpmExecuteRegister;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class OrderActionTpmExecuteRegisterImpl
implements ActionTpmExecuteRegister {
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderRepository orderRepository;

    public String relationKey() {
        return "order";
    }

    public String relationName() {
        return "\u8ba2\u5355\u6a21\u5757";
    }

    @Transactional
    public void onCreate(ActionTpmExecuteVo vo) {
        List list;
        Validate.notNull((Object)vo, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List list2 = list = Objects.isNull(vo.getRelationMap()) ? null : (List)vo.getRelationMap().get("order");
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<OrderEntity> entities = list.stream().map(jsonObject -> {
            OrderEntity entity = (OrderEntity)((Object)((Object)JsonUtils.json2Obj((String)jsonObject.toJSONString(), OrderEntity.class)));
            entity.setSourceType(OrderSourceType.ACTION_ORDER.getDictCode());
            entity.setSourceCode(vo.getExecuteCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setTerminalCode(vo.getTerminalCode());
            entity.setTerminalName(vo.getTerminalName());
            return entity;
        }).collect(Collectors.toList());
        this.orderService.createBatch(entities);
        vo.setActivitiesDetailSerials((List)ObjectUtils.defaultIfNull((Object)vo.getActivitiesDetailSerials(), (Object)Lists.newArrayList()));
        vo.getActivitiesDetailSerials().addAll(entities.stream().map(entity -> {
            ActivitiesDetailSerialVo serialVo = new ActivitiesDetailSerialVo();
            serialVo.setActivitiesCode(vo.getActionCode());
            serialVo.setActivitiesDetailCode(vo.getActionDetailCode());
            serialVo.setActivitiesName(vo.getActionName());
            serialVo.setBtNo(vo.getExecuteCode());
            serialVo.setCustomerCode(entity.getSuperiorCustomerCode());
            serialVo.setCustomerName(entity.getSuperiorCustomerName());
            serialVo.setSerialNo(entity.getOrderCode());
            serialVo.setSerialPrice(BigDecimal.valueOf(entity.getProducts().stream().mapToDouble(value -> value.getQuantity().multiply(value.getPrice()).doubleValue()).sum()));
            serialVo.setSerialTime(entity.getCreateTime());
            serialVo.setCreateTime(entity.getCreateTime());
            serialVo.setTerminalCode(entity.getTerminalCode());
            serialVo.setTerminalName(entity.getTerminalName());
            serialVo.setType(Integer.valueOf(1));
            return serialVo;
        }).collect(Collectors.toList()));
    }

    public Map<String, List<JSONObject>> onRequestByExecuteCodes(Set<String> executeCodes) {
        if (CollectionUtils.isEmpty(executeCodes)) {
            return null;
        }
        OrderConditionModel model = new OrderConditionModel();
        model.setTenantCode(TenantUtils.getTenantCode());
        model.setSourceCodes(executeCodes);
        model.setSourceType(OrderSourceType.ACTION_ORDER.getDictCode());
        List<OrderEntity> entities = this.orderRepository.findByOrderConditionModel(model);
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return entities.stream().collect(Collectors.groupingBy(OrderEntity::getSourceCode, Collectors.mapping(o -> {
            JSONObject jsonObject = JsonUtils.toJSONObject((Object)o);
            jsonObject.put("createTime", (Object)DateFormatUtils.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            jsonObject.put("modifyTime", (Object)DateFormatUtils.format((Date)o.getModifyTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return jsonObject;
        }, Collectors.toList())));
    }
}

