package com.biz.crm.sfa.business.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 考勤规则分页Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderPageDto", description = "订单分页Dto")
public class OrderPageDto extends TenantFlagOpDto {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 来源类型
   * @see com.biz.crm.sfa.business.order.sdk.enums.OrderSourceType
   */
  @ApiModelProperty("来源类型")
  private String sourceType;
}
