package com.biz.crm.sfa.business.overtime.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyService;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 加班:  OvertimeApply: 加班申请
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/overtime/overtimeApply")
@Api(tags = "加班:  OvertimeApply: 加班申请")
public class OvertimeApplyController {

  @Autowired
  private OvertimeApplyService overtimeApplyService;

  /**
   * 移动端-创建加班申请
   *
   * @param dto 参数dto
   * @return 加班申请
   */
  @ApiOperation(value = "移动端-创建加班申请")
  @PostMapping("create")
  public Result<OvertimeApplyEntity> create(@RequestBody OvertimeApplyDto dto) {
    try {
      return Result.ok(this.overtimeApplyService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-修改加班申请
   *
   * @param dto 参数dto
   * @return 加班申请
   */
  @ApiOperation(value = "移动端-修改加班申请")
  @PostMapping("update")
  public Result<OvertimeApplyEntity> update(@RequestBody OvertimeApplyDto dto) {
    try {
      return Result.ok(this.overtimeApplyService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
