package com.biz.crm.sfa.business.overtime.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyPageDto;
import com.biz.crm.sfa.business.overtime.sdk.service.OvertimeApplyVoService;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 加班: OvertimeApplyVo: 加班申请
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/overtime/overtimeApply")
@Api(tags = "加班: OvertimeApplyVo: 加班申请")
public class OvertimeApplyVoController {

  @Autowired
  private OvertimeApplyVoService overtimeApplyVoService;

  /**
   * 移动端-加班申请分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OvertimeApplyVo> 加班申请分页信息
   */
  @ApiOperation(value = "移动端-加班申请分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<OvertimeApplyVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "AttendanceFillApplyPageDto", value = "分页Dto") OvertimeApplyPageDto dto) {
    try {
      return Result.ok(this.overtimeApplyVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过ID查询加班申请信息
   *
   * @param id ID
   * @return 加班申请信息
   */
  @ApiOperation(value = "通过ID获取加班申请信息")
  @GetMapping("/findById")
  public Result<OvertimeApplyVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<OvertimeApplyVo> list = this.overtimeApplyVoService.findByIds(Lists.newArrayList(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 加班申请详情报表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<OvertimeApplyVo> 加班申请分页信息
   */
  @ApiOperation(value = "加班申请详情报表")
  @GetMapping("/findDetailsByConditions")
  public Result<Page<OvertimeApplyVo>> findDetailsByConditions(@PageableDefault(50) Pageable pageable,
                                                        @ApiParam(name = "AttendanceFillApplyPageDto", value = "分页Dto") OvertimeApplyPageDto dto) {
    try {
      return Result.ok(this.overtimeApplyVoService.findDetailsByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
