package com.biz.crm.sfa.business.overtime.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 加班申请实体类
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OvertimeApplyEntity", description = "加班申请实体类")
@Entity
@TableName("sfa_overtime_apply")
@Table(name = "sfa_overtime_apply", indexes = {
    @Index(name = "sfa_overtime_apply_index1", columnList = "apply_code", unique = true),
    @Index(name = "sfa_overtime_apply_index2", columnList = "user_name"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_overtime_apply", comment = "加班申请表")
public class OvertimeApplyEntity extends WorkflowFlagOpEntity {

  private static final long serialVersionUID = 5955692626534831917L;

  /**
   * 申请编码
   */
  @ApiModelProperty("申请编码")
  @Column(name = "apply_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '申请编码'")
  private String applyCode;

  /**
   * 加班调整类型(normal普通调整，legal节假日调整)
   *
   * @see com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeType
   */
  @ApiModelProperty("加班调整类型")
  @Column(name = "overtime_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '加班调整类型(normal普通调整，legal节假日调整)'")
  private String overtimeType;

  /**
   * 申请原因
   */
  @ApiModelProperty("申请原因")
  @Column(name = "apply_reason", length = 512, columnDefinition = "VARCHAR(512) COMMENT '申请原因'")
  private String applyReason;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '人员账号'")
  private String userName;

  /**
   * 人员姓名 人员姓名
   */
  @Column(name = "real_name", length = 100, columnDefinition = "varchar(32) COMMENT '人员姓名 人员姓名'")
  @ApiModelProperty("人员姓名")
  private String realName;

  /**
   * 职位编码 职位编码
   */
  @Column(name = "pos_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码 职位编码'")
  @ApiModelProperty("职位编码")
  private String posCode;

  /**
   * 职位名称 职位名称
   */
  @Column(name = "pos_name", length = 100, columnDefinition = "varchar(100) COMMENT '职位名称 职位名称'")
  @ApiModelProperty("职位名称")
  private String posName;

  /**
   * 所属组织编码 所属组织编码
   */
  @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT '所属组织编码 所属组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 所属组织名称 所属组织名称
   */
  @Column(name = "org_name", length = 100, columnDefinition = "varchar(100) COMMENT '所属组织名称 所属组织名称'")
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 上级组织编码
   */
  @Column(name = "parent_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级组织编码'")
  @ApiModelProperty("上级组织编码")
  private String parentOrgCode;

  /**
   * 上级组织名称
   */
  @Column(name = "parent_org_name", length = 64, columnDefinition = "varchar(64) COMMENT '上级组织名称'")
  @ApiModelProperty("上级组织名称")
  private String parentOrgName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:ss)")
  @Column(name = "apply_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '申请日期(yyyy-MM-dd HH:mm:ss)'")
  private String applyDate;

  /**
   * 开始时间(yyyy-MM-dd)
   */
  @ApiModelProperty("开始时间(yyyy-MM-dd)")
  @Column(name = "begin_time", length = 20, columnDefinition = "VARCHAR(20) COMMENT '开始时间(yyyy-MM-dd)'")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd)
   */
  @ApiModelProperty("结束时间(yyyy-MM-dd)")
  @Column(name = "end_time", length = 20, columnDefinition = "VARCHAR(20) COMMENT '结束时间(yyyy-MM-dd)'")
  private String endTime;

  /**
   * 日期明细json
   */
  @ApiModelProperty("日期明细json")
  @Column(name = "time_info_list_json", length = 512, columnDefinition = "VARCHAR(512) COMMENT '日期明细json'")
  private String timeInfoListJson;

  /**
   * 申请时长(天)
   */
  @ApiModelProperty("申请时长(天)")
  @Column(name = "apply_duration", columnDefinition = "decimal(10,2) COMMENT '申请时长(天)'")
  private BigDecimal applyDuration;

  /**
   * 审批通过时间(yyyy-MM-dd HH:mm:ss)
   */
  @ApiModelProperty("审批通过时间(yyyy-MM-dd HH:mm:ss)")
  @Column(name = "audit_pass_date", length = 20, columnDefinition = "VARCHAR(20) COMMENT '审批通过时间(yyyy-MM-dd HH:mm:ss)'")
  private String auditPassDate;

  /**
   * 节假日天数
   */
  @ApiModelProperty("节假日天数")
  @Column(name = "holiday_days", columnDefinition = "decimal(10,2) COMMENT '节假日天数'")
  private BigDecimal holidayDays;

  /**
   * 加班匹配的考勤规则编码
   */
  @ApiModelProperty("加班匹配的考勤规则编码")
  @Column(name = "rule_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '加班匹配的考勤规则编码'")
  private String ruleCode;
}
