package com.biz.crm.sfa.business.overtime.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 加班申请时间明细实体类
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OvertimeApplyEntity", description = "加班申请时间明细实体类")
@Entity
@TableName("sfa_overtime_apply_time")
@Table(name = "sfa_overtime_apply_time", indexes = {
    @Index(name = "sfa_overtime_apply_time_index1", columnList = "apply_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_overtime_apply_time", comment = "加班申请时间明细表")
public class OvertimeApplyTimeEntity extends UuidOpEntity {

  private static final long serialVersionUID = -7217024250531792652L;

  /**
   * 申请ID
   */
  @ApiModelProperty("申请ID")
  @Column(name = "apply_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '申请ID'")
  private String applyId;

  /**
   * 明细时间(yyyy-MM-dd)
   */
  @ApiModelProperty("明细时间(yyyy-MM-dd)")
  @Column(name = "item_time", length = 20, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '明细时间(yyyy-MM-dd)'")
  private String itemTime;

  /**
   * 时间类型(all_day:全天;forenoon:上午;afternoon:下午)
   *
   * @see com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeTimeType
   */
  @ApiModelProperty("时间类型(all_day:全天;forenoon:上午;afternoon:下午)")
  @Column(name = "time_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '时间类型(all_day:全天;forenoon:上午;afternoon:下午)'")
  private String timeType;
}
