package com.biz.crm.sfa.business.overtime.local.service.internal;

import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceFillApplyVo;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyTimeEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyTimeRepository;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyTimeService;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyDto;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeTimeType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 加班申请时间明细表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-30 11:34:25
 */
@Slf4j
@Service("overtimeApplyTimeService")
public class OvertimeApplyTimeServiceImpl implements OvertimeApplyTimeService {

  @Autowired
  private OvertimeApplyTimeRepository overtimeApplyTimeRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<OvertimeApplyTimeEntity> buildTimeEntities(List<OvertimeApplyTimeDto> timeList) {
    if (CollectionUtils.isEmpty(timeList)) {
      return Lists.newLinkedList();
    }
    timeList.sort(Comparator.comparing(OvertimeApplyTimeDto::getItemTime));
    List<OvertimeApplyTimeEntity> list = Lists.newArrayList();
    list.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(timeList
        , OvertimeApplyTimeDto.class, OvertimeApplyTimeEntity.class, HashSet.class, ArrayList.class));
    OvertimeApplyTimeDto startTimeDto = timeList.get(0);
    OvertimeApplyTimeDto endTimeDto = timeList.get(timeList.size() - 1);
    long days = LocalDate.parse(startTimeDto.getItemTime()).until(LocalDate.parse(endTimeDto.getItemTime()), ChronoUnit.DAYS);
    if (days > 1) {
      for (long i = 1; i < days; i++) {
        OvertimeApplyTimeEntity timeEntity = new OvertimeApplyTimeEntity();
        timeEntity.setTimeType(OvertimeTimeType.ALL_DAY.getDictCode());
        timeEntity.setItemTime(LocalDate.parse(startTimeDto.getItemTime()).plusDays(i).format(OvertimeConstant.YYYY_MM_DD));
        list.add(timeEntity);
      }
    }
    list.sort(Comparator.comparing(OvertimeApplyTimeEntity::getItemTime));
    return list;
  }
}
