package com.biz.crm.sfa.business.overtime.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyPageDto;
import com.biz.crm.sfa.business.overtime.sdk.service.OvertimeApplyVoService;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyTimeVo;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 加班申请Vo服务接口实现
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Slf4j
@Service
public class OvertimeApplyVoServiceImpl implements OvertimeApplyVoService {

  @Autowired
  private OvertimeApplyRepository overtimeApplyRepository;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private PositionVoService positionVoService;
  @Autowired
  private UserInfoVoService userInfoVoService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private UserVoService userVoService;

  @Override
  public List<OvertimeApplyVo> findByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newLinkedList();
    }
    List<OvertimeApplyEntity> entities = this.overtimeApplyRepository.listByIds(ids);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<OvertimeApplyVo> list = entities.stream().map(entity -> {
      OvertimeApplyVo vo = this.nebulaToolkitService.copyObjectByBlankList(entity, OvertimeApplyVo.class, HashSet.class, ArrayList.class);
      vo.setTimeList(JSON.parseArray(entity.getTimeInfoListJson(), OvertimeApplyTimeVo.class));
      return vo;
    }).collect(Collectors.toList());
    this.perfectUserInfo(list);
    return list;
  }

  @Override
  public List<OvertimeApplyVo> findByProcessStatus(String processStatus) {
    if (StringUtils.isBlank(processStatus)) {
      return Lists.newLinkedList();
    }
    OvertimeApplyConditionDto overtimeApplyConditionDto = new OvertimeApplyConditionDto();
    overtimeApplyConditionDto.setIncludeProcessStatusList(Collections.singletonList(processStatus));
    overtimeApplyConditionDto.setTenantCode(TenantUtils.getTenantCode());
    List<OvertimeApplyEntity> entities = this.overtimeApplyRepository.findByOvertimeApplyConditionDto(overtimeApplyConditionDto);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<OvertimeApplyVo> list = entities.stream().map(entity -> {
      OvertimeApplyVo vo = this.nebulaToolkitService.copyObjectByBlankList(entity, OvertimeApplyVo.class, HashSet.class, ArrayList.class);
      vo.setTimeList(JSON.parseArray(entity.getTimeInfoListJson(), OvertimeApplyTimeVo.class));
      return vo;
    }).collect(Collectors.toList());
    this.perfectUserInfo(list);
    return list;
  }

  @Override
  public Page<OvertimeApplyVo> findByConditions(Pageable pageable, OvertimeApplyPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new OvertimeApplyPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    dto.setUserNames(Sets.newHashSet(loginDetails.getAccount()));
    List<PositionVo> positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
    if (!CollectionUtils.isEmpty(positionList)) {
      List<UserInfoVo> userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()));
      if (!org.springframework.util.CollectionUtils.isEmpty(userList)) {
        dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
      }
    }
    //如果搜索了关键字,需要查询关键字对应的用户集合
    if (StringUtils.isNotBlank(dto.getKeyWord())) {
      UserConditionDto userConditionDto = new UserConditionDto();
      userConditionDto.setFullName(dto.getKeyWord());
      dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateStart())) {
      dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), OvertimeConstant.TIME_STR_000000));
    }
    if (StringUtils.isNotEmpty(dto.getApplyDateEnd())) {
      dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), OvertimeConstant.TIME_STR_235959));
    }
    Page<OvertimeApplyEntity> entityPage = this.overtimeApplyRepository.findByConditions(pageable, dto);
    Page<OvertimeApplyVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (org.springframework.util.CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    List<OvertimeApplyVo> list = (List<OvertimeApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entityPage.getRecords()
        , OvertimeApplyEntity.class, OvertimeApplyVo.class, HashSet.class, ArrayList.class);
    this.perfectUserInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public Page<OvertimeApplyVo> findDetailsByConditions(Pageable pageable, OvertimeApplyPageDto dto) {
    LoginUserDetails loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    dto.setTenantCode(loginUserDetails.getTenantCode());
    Page<OvertimeApplyEntity> entityPage = this.overtimeApplyRepository.findByConditions(pageable, dto);
    Page<OvertimeApplyVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (org.springframework.util.CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    List<OvertimeApplyVo> list = (List<OvertimeApplyVo>) this.nebulaToolkitService.copyCollectionByBlankList(entityPage.getRecords()
            , OvertimeApplyEntity.class, OvertimeApplyVo.class, HashSet.class, ArrayList.class);
    this.perfectUserInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public List<OvertimeApplyTimeVo> findOvertimeApplyTimeByConditions(OvertimeApplyConditionDto dto) {
    if (Objects.isNull(dto)) {
      return Lists.newLinkedList();
    }
    if(CollectionUtils.isEmpty(dto.getUserNames()) || CollectionUtils.isEmpty(dto.getIncludeProcessStatusList())){
      return Lists.newArrayList();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    List<OvertimeApplyEntity> entities = this.overtimeApplyRepository.findByOvertimeApplyConditionDto(dto);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<OvertimeApplyTimeVo> overtimeApplyTimeVos = new ArrayList<>();
    entities.forEach(
        entity -> {
          List<OvertimeApplyTimeVo> overtimeApplyTimeVoList =
              JSON.parseArray(entity.getTimeInfoListJson(), OvertimeApplyTimeVo.class);
          for (OvertimeApplyTimeVo overtimeApplyTimeVo : overtimeApplyTimeVoList) {
            overtimeApplyTimeVo.setUserName(entity.getUserName());
          }
          overtimeApplyTimeVos.addAll(overtimeApplyTimeVoList);
        });
    return overtimeApplyTimeVos;
  }

  /**
   * 完善补打卡申请用户信息
   *
   * @param list 补打卡申请
   */
  private void perfectUserInfo(List<OvertimeApplyVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().map(OvertimeApplyVo::getUserName).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
      vo.setPositionCode(userVo.getPositionCode());
      vo.setPositionName(userVo.getPositionName());
      vo.setOrgCode(userVo.getOrgCode());
      vo.setOrgName(userVo.getOrgName());
      vo.setUserRealName(userVo.getFullName());
    });
  }
}
