package com.biz.crm.sfa.business.overtime.local.service.observer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyTimeEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyTimeRepository;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyTimeService;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import com.biz.crm.sfa.business.overtime.sdk.event.OvertimeApplyEventListener;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;


/**
 * 加班审批回调类
 *
 * @author ning.zhang
 * @date 2022/6/2
 */
@Component
public class OvertimeApplyCallbackListener implements CallBackListener {

  @Autowired
  private OvertimeApplyRepository overtimeApplyRepository;
  @Autowired
  private OvertimeApplyTimeRepository overtimeApplyTimeRepository;
  @Autowired
  private OvertimeApplyTimeService overtimeApplyTimeService;
  @Autowired(required = false)
  private List<OvertimeApplyEventListener> listeners;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void onCallBack(CallBackDto dto) {
    if (!dto.getFormType().equals(OvertimeConstant.OVERTIME_APPLY_PROCESS_FORM_TYPE)) {
      return;
    }
    OvertimeApplyEntity applyEntity = this.overtimeApplyRepository.findByProcessNumber(dto.getProcessNo(), TenantUtils.getTenantCode());
    if (Objects.isNull(applyEntity)) {
      return;
    }
    //校验审批状态
    Validate.isTrue(applyEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), "此申请非审批中状态，无法进行操作！");
    //根据回调类别处理对应业务
    if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.APPROVED.getCode())) {
      //审批通过业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
      applyEntity.setAuditPassDate(LocalDateTime.now().format(OvertimeConstant.YYYY_MM_DD_HH_MM_SS));
      List<OvertimeApplyTimeDto> timeList = JSON.parseArray(applyEntity.getTimeInfoListJson(), OvertimeApplyTimeDto.class);
      List<OvertimeApplyTimeEntity> timeEntities = this.overtimeApplyTimeService.buildTimeEntities(timeList);
      timeEntities.forEach(entity -> entity.setApplyId(applyEntity.getId()));
      this.overtimeApplyTimeRepository.saveBatch(timeEntities);
      //发起事件通知上层模块
      if (!CollectionUtils.isEmpty(listeners)) {
        OvertimeApplyVo overtimeApplyVo = this.nebulaToolkitService.copyObjectByBlankList(applyEntity
            , OvertimeApplyVo.class, HashSet.class, ArrayList.class);
        this.listeners.forEach(listener -> listener.onApproved(overtimeApplyVo));
      }
    } else if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.REJECTED.getCode())) {
      //审批驳回业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.REJECTED.getCode());
    } else if (StringUtils.equals(String.valueOf(dto.getProcessState()), ActApproveStatusEnum.INTERRUPT.getCode())) {
      //流程追回业务处理
      applyEntity.setProcessStatus(ActApproveStatusEnum.INTERRUPT.getCode());
    }
    this.overtimeApplyRepository.updateById(applyEntity);
  }
}
