/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.overtime.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceRuleScopeType;
import com.biz.crm.sfa.business.attendance.sdk.enums.AttendanceSpecialDateType;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRuleVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleScopeVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleSpecialDateVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayConditionDto;
import com.biz.crm.sfa.business.holiday.sdk.service.HolidayVoService;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayDateVo;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyTimeEntity;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeRuleEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeRuleRepository;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyService;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyTimeService;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyDto;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeTimeType;
import com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeType;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.OrgInfoDto;
import com.biz.crm.workflow.sdk.dto.StartProcessDto;
import com.biz.crm.workflow.sdk.listener.OrgInfoListener;
import com.biz.crm.workflow.sdk.listener.ProcessListener;
import com.biz.crm.workflow.sdk.vo.OrgVo;
import com.biz.crm.workflow.sdk.vo.response.CommitWorkflowResponse;
import com.biz.crm.workflow.sdk.vo.response.OrgInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="overtimeApplyService")
public class OvertimeApplyServiceImpl
implements OvertimeApplyService {
    private static final Logger log = LoggerFactory.getLogger(OvertimeApplyServiceImpl.class);
    @Autowired
    private OvertimeApplyRepository overtimeApplyRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private HolidayVoService holidayVoService;
    @Autowired
    private AttendanceRuleVoService attendanceRuleVoService;
    @Autowired
    private OvertimeApplyTimeService overtimeApplyTimeService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private OvertimeRuleRepository overtimeRuleRepository;
    @Autowired
    private PositionVoService positionVoService;

    @Override
    @Transactional
    public OvertimeApplyEntity create(OvertimeApplyDto dto) {
        this.createValidation(dto);
        OvertimeApplyEntity entity = (OvertimeApplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, OvertimeApplyEntity.class, HashSet.class, ArrayList.class, new String[]{"recordIds"}));
        entity.setTimeInfoListJson(JSON.toJSONString((Object)dto.getTimeList()));
        entity.setApplyCode((String)this.generateCodeService.generateCode("OA", 1).get(0));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.overtimeApplyRepository.save((Object)entity);
        dto.setId(entity.getId());
        dto.setApplyCode(entity.getApplyCode());
        entity.setProcessNumber(this.commitProcess(dto));
        this.overtimeApplyRepository.updateById((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public OvertimeApplyEntity update(OvertimeApplyDto dto) {
        this.updateValidation(dto);
        OvertimeApplyEntity applyEntity = (OvertimeApplyEntity)((Object)this.overtimeApplyRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)applyEntity), (String)"\u52a0\u73ed\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((ActApproveStatusEnum.REJECTED.getCode().equals(applyEntity.getProcessStatus()) || ActApproveStatusEnum.INTERRUPT.getCode().equals(applyEntity.getProcessStatus()) ? 1 : 0) != 0, (String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91", (Object[])new Object[0]);
        if (ActApproveStatusEnum.REJECTED.getCode().equals(applyEntity.getProcessStatus())) {
            dto.setId(null);
        }
        OvertimeApplyEntity entity = (OvertimeApplyEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, OvertimeApplyEntity.class, HashSet.class, ArrayList.class, new String[]{"recordIds"}));
        entity.setTimeInfoListJson(JSON.toJSONString((Object)dto.getTimeList()));
        entity.setApplyCode(StringUtils.isNotBlank((CharSequence)entity.getId()) ? applyEntity.getApplyCode() : (String)this.generateCodeService.generateCode("OA", 1).get(0));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setProcessStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.overtimeApplyRepository.saveOrUpdate((Object)entity);
        dto.setId(entity.getId());
        dto.setApplyCode(entity.getApplyCode());
        entity.setProcessNumber(this.commitProcess(dto));
        this.overtimeApplyRepository.updateById((Object)entity);
        return entity;
    }

    private String commitProcess(OvertimeApplyDto dto) {
        StartProcessDto startProcessDto = new StartProcessDto();
        startProcessDto.setProcessKey("overtime_apply_process001");
        startProcessDto.setBusinessId(dto.getId());
        startProcessDto.setBusinessNo(dto.getApplyCode());
        startProcessDto.setRemark(dto.getProcessRemark());
        startProcessDto.setFormType("overtime_apply");
        startProcessDto.setProcessTitle("\u52a0\u73ed\u5ba1\u6279\u6d41\u7a0b");
        startProcessDto.setMenuCode(dto.getCompetenceCode());
        SerializableBiConsumer & Serializable sf = ProcessListener::onStartProcess;
        CommitWorkflowResponse response = (CommitWorkflowResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)startProcessDto, ProcessListener.class, (SerializableBiConsumer)sf);
        Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)response.getProcessInstanceId()), (String)"\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25\uff01", (Object[])new Object[0]);
        return response.getProcessInstanceId();
    }

    private void createValidation(OvertimeApplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getApplyDuration()) && dto.getApplyDuration().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u65f6\u957f\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        dto.setRealName(loginDetails.getUsername());
        dto.setOrgCode(loginDetails.getOrgCode());
        dto.setOrgName(loginDetails.getOrgName());
        dto.setPosCode(loginDetails.getPostCode());
        dto.setPosName(loginDetails.getPostName());
        dto.setApplyDate(LocalDateTime.now().format(OvertimeConstant.YYYY_MM_DD_HH_MM_SS));
        SerializableBiConsumer & Serializable orgConsumer = OrgInfoListener::findByOrgCodes;
        OrgInfoDto orgInfoDto = new OrgInfoDto();
        orgInfoDto.setOrgCode(dto.getOrgCode());
        OrgInfoResponse orgResponse = (OrgInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)orgInfoDto, OrgInfoListener.class, (SerializableBiConsumer)orgConsumer);
        if (ObjectUtils.isNotEmpty((Object)orgResponse) && !CollectionUtils.isEmpty((Collection)orgResponse.getRoleInfoVos())) {
            OrgVo orgVo = (OrgVo)orgResponse.getRoleInfoVos().get(0);
            dto.setParentOrgCode(orgVo.getParentCode());
            dto.setParentOrgName(orgVo.getParentName());
        }
        List<OvertimeApplyTimeEntity> timeEntities = this.validateApplyTime(dto);
        this.validateAttendanceRule(dto, timeEntities);
    }

    private void updateValidation(OvertimeApplyDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getApplyDuration()) && dto.getApplyDuration().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u65f6\u957f\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
        Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        dto.setOrgCode(loginDetails.getOrgCode());
        dto.setPosCode(loginDetails.getPostCode());
        dto.setApplyDate(LocalDateTime.now().format(OvertimeConstant.YYYY_MM_DD_HH_MM_SS));
        List<OvertimeApplyTimeEntity> timeEntities = this.validateApplyTime(dto);
        this.validateAttendanceRule(dto, timeEntities);
    }

    private void validateAttendanceRule(OvertimeApplyDto dto, List<OvertimeApplyTimeEntity> timeEntities) {
        List specialDateList;
        dto.setOvertimeType(OvertimeType.NORMAL.getDictCode());
        List<OvertimeRuleEntity> overtimeRuleEntities = this.overtimeRuleRepository.findByAbideFlag(BooleanEnum.TRUE.getCapital(), TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(overtimeRuleEntities) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219", (Object[])new Object[0]);
        RuleConditionDto conditionDto = new RuleConditionDto();
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setOrgCodes((List)Lists.newArrayList((Object[])new String[]{dto.getOrgCode()}));
        conditionDto.setRuleCodes(overtimeRuleEntities.stream().map(OvertimeRuleEntity::getRuleCode).collect(Collectors.toList()));
        List attendanceRuleList = this.attendanceRuleVoService.findByRuleConditionDto(conditionDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)attendanceRuleList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219", (Object[])new Object[0]);
        attendanceRuleList = attendanceRuleList.stream().filter(ruleVo -> {
            List scopeList = ruleVo.getScopeList();
            if (CollectionUtils.isEmpty((Collection)scopeList)) {
                return false;
            }
            Map<String, List<AttendanceRuleScopeVo>> scopeMap = scopeList.stream().collect(Collectors.groupingBy(AttendanceRuleScopeVo::getScopeType));
            if (scopeMap.keySet().size() == 1 && !CollectionUtils.isEmpty((Collection)scopeMap.get(AttendanceRuleScopeType.ORG.getDictCode()))) {
                return true;
            }
            if (scopeMap.keySet().size() > 1) {
                List positionList = this.positionVoService.findByIdsOrCodes((List)Lists.newLinkedList(), (List)Lists.newArrayList((Object[])new String[]{dto.getPosCode()}));
                List<Object> scopeVoList = scopeMap.getOrDefault(AttendanceRuleScopeType.POSITION_LEVEL.getDictCode(), Lists.newArrayList());
                if (CollectionUtils.isEmpty((Collection)positionList)) {
                    return false;
                }
                return !CollectionUtils.isEmpty(scopeVoList = scopeVoList.stream().filter(scopeVo -> scopeVo.getScopeCode().equals(((PositionVo)positionList.get(0)).getPositionLevelCode())).collect(Collectors.toList()));
            }
            return false;
        }).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(attendanceRuleList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219", (Object[])new Object[0]);
        AttendanceRuleVo attendanceRuleVo = (AttendanceRuleVo)attendanceRuleList.get(0);
        dto.setRuleCode(attendanceRuleVo.getRuleCode());
        List<HolidayDateVo> holidayDateList = this.validateHoliday(dto, timeEntities, attendanceRuleVo);
        if (!CollectionUtils.isEmpty(holidayDateList)) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)attendanceRuleVo.getSpecialDateList()) && !CollectionUtils.isEmpty(specialDateList = attendanceRuleVo.getSpecialDateList().stream().filter(specialDateVo -> Objects.nonNull(specialDateVo) && dto.getBeginTime().compareTo(specialDateVo.getSpecialDate()) <= 0 && dto.getEndTime().compareTo(specialDateVo.getSpecialDate()) >= 0 && AttendanceSpecialDateType.MUST_CLOCK.getDictCode().equals(specialDateVo.getSpecialDateType())).collect(Collectors.toList()))) {
            throw new IllegalArgumentException(String.format("\u65e5\u671f\u4e0d\u80fd\u7533\u8bf7\u52a0\u73ed-\u5de5\u4f5c\u65e5\uff1a%s", ((AttendanceRuleSpecialDateVo)specialDateList.get(0)).getSpecialDate()));
        }
        timeEntities.forEach(entity -> {
            LocalDate date = LocalDate.parse(entity.getItemTime());
            Validate.isTrue((!attendanceRuleVo.getWorkingDay().contains(String.valueOf(date.getDayOfWeek().getValue())) ? 1 : 0) != 0, (String)String.format("\u65e5\u671f\u4e0d\u80fd\u7533\u8bf7\u52a0\u73ed-\u5de5\u4f5c\u65e5\uff1a%s", date.format(OvertimeConstant.YYYY_MM_DD)), (Object[])new Object[0]);
        });
    }

    private List<HolidayDateVo> validateHoliday(OvertimeApplyDto dto, List<OvertimeApplyTimeEntity> timeEntities, AttendanceRuleVo attendanceRuleVo) {
        List<Object> holidayDateList = Lists.newArrayList();
        HolidayConditionDto holidayConditionDto = new HolidayConditionDto();
        holidayConditionDto.setYears((Set)Sets.newHashSet((Object[])new String[]{String.valueOf(LocalDate.parse(dto.getEndTime()).getYear()), String.valueOf(LocalDate.parse(dto.getBeginTime()).getYear())}));
        List holidayList = this.holidayVoService.findByHolidayConditionDto(holidayConditionDto);
        HashMap holidayMap = CollectionUtils.isEmpty((Collection)holidayList) ? Maps.newHashMap() : holidayList.stream().collect(Collectors.toMap(HolidayVo::getYear, t -> t, (a, b) -> b));
        dto.setHolidayDays(BigDecimal.ZERO);
        if (BooleanEnum.TRUE.getCapital().equals(attendanceRuleVo.getSyncHoliday())) {
            holidayConditionDto.getYears().forEach(year -> Validate.notNull(holidayMap.get(year), (String)String.format("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e%s\u5e74\u5ea6\u8282\u5047\u65e5\u4fe1\u606f", year), (Object[])new Object[0]));
            Map<String, OvertimeApplyTimeEntity> timeEntityMap = timeEntities.stream().collect(Collectors.toMap(OvertimeApplyTimeEntity::getItemTime, t -> t));
            holidayDateList = holidayList.stream().flatMap(holidayVo -> holidayVo.getInfoList().stream().flatMap(holidayInfoVo -> holidayInfoVo.getDateList().stream())).collect(Collectors.toList()).stream().filter(holidayDateVo -> Objects.nonNull(holidayDateVo) && dto.getBeginTime().compareTo(holidayDateVo.getHolidayDate()) <= 0 && dto.getEndTime().compareTo(holidayDateVo.getHolidayDate()) >= 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)holidayDateList)) {
                return holidayDateList;
            }
            holidayDateList.forEach(holidayDateVo -> {
                if (holidayDateVo.getCalculationSalary().equals(BooleanEnum.TRUE.getCapital())) {
                    OvertimeApplyTimeEntity timeEntity = (OvertimeApplyTimeEntity)((Object)((Object)timeEntityMap.get(holidayDateVo.getHolidayDate())));
                    dto.setOvertimeType(OvertimeType.HOLIDAY.getDictCode());
                    dto.setHolidayDays(dto.getHolidayDays().add(OvertimeTimeType.ALL_DAY.getDictCode().equals(timeEntity.getTimeType()) ? BigDecimal.ONE : BigDecimal.valueOf(0.5)));
                }
            });
        }
        return holidayDateList;
    }

    private List<OvertimeApplyTimeEntity> validateApplyTime(OvertimeApplyDto dto) {
        List timeList = dto.getTimeList();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)timeList) && timeList.size() <= 2 ? 1 : 0) != 0, (String)"\u65e5\u671f\u65f6\u95f4\u660e\u7ec6\u9519\u8bef", (Object[])new Object[0]);
        timeList.forEach(timeDto -> {
            Validate.notBlank((CharSequence)timeDto.getItemTime(), (String)"\u7f3a\u5931\u660e\u7ec6\u65f6\u95f4", (Object[])new Object[0]);
            Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)timeDto.getItemTime()), (String)"\u975e\u6cd5\u7684\u660e\u7ec6\u65f6\u95f4\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
            Validate.notNull((Object)OvertimeTimeType.getByDictCode((String)timeDto.getTimeType()), (String)"\u65f6\u95f4\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        });
        List<OvertimeApplyTimeEntity> timeEntities = this.overtimeApplyTimeService.buildTimeEntities(timeList);
        Validate.isTrue((dto.getBeginTime().compareTo(timeEntities.get(0).getItemTime()) == 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u5f00\u59cb\u65f6\u95f4\u4e0e\u660e\u7ec6\u5f00\u59cb\u65f6\u95f4\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        Validate.isTrue((dto.getEndTime().compareTo(timeEntities.get(timeEntities.size() - 1).getItemTime()) == 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u7ed3\u675f\u65f6\u95f4\u4e0e\u660e\u7ec6\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        BigDecimal applyDuration = timeEntities.stream().map(entity -> OvertimeTimeType.getByDictCode((String)entity.getTimeType()).getDays()).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((applyDuration.compareTo(dto.getApplyDuration()) == 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u65f6\u957f\u548c\u660e\u7ec6\u65f6\u95f4\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        this.validateConflictTime(dto, timeEntities);
        return timeEntities;
    }

    private void validateConflictTime(OvertimeApplyDto dto, List<OvertimeApplyTimeEntity> timeEntities) {
        OvertimeApplyConditionDto applyConditionDto = new OvertimeApplyConditionDto();
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            applyConditionDto.setExcludeIds((List)Lists.newArrayList((Object[])new String[]{dto.getId()}));
        }
        applyConditionDto.setTenantCode(dto.getTenantCode());
        applyConditionDto.setEndTime(dto.getEndTime());
        applyConditionDto.setBeginTime(dto.getBeginTime());
        applyConditionDto.setUserName(dto.getUserName());
        applyConditionDto.setExcludeProcessStatusList((List)Lists.newArrayList((Object[])new String[]{ActApproveStatusEnum.REJECTED.getCode(), ActApproveStatusEnum.INTERRUPT.getCode()}));
        List<OvertimeApplyEntity> applyEntities = this.overtimeApplyRepository.findByOvertimeApplyConditionDto(applyConditionDto);
        if (CollectionUtils.isEmpty(applyEntities)) {
            return;
        }
        List repeatTimeList = applyEntities.stream().flatMap(entity -> this.overtimeApplyTimeService.buildTimeEntities(JSON.parseArray((String)entity.getTimeInfoListJson(), OvertimeApplyTimeDto.class)).stream()).flatMap(entity -> {
            HashSet typeList = Sets.newHashSet((Object[])new String[]{entity.getTimeType()});
            if (OvertimeTimeType.ALL_DAY.getDictCode().equals(entity.getTimeType())) {
                typeList.add(OvertimeTimeType.FORENOON.getDictCode());
                typeList.add(OvertimeTimeType.AFTERNOON.getDictCode());
            }
            return typeList.stream().map(type -> {
                OvertimeApplyTimeEntity timeEntity = new OvertimeApplyTimeEntity();
                timeEntity.setTimeType((String)type);
                timeEntity.setItemTime(entity.getItemTime());
                return timeEntity;
            });
        }).map(entity -> String.format("%s%s", entity.getItemTime(), entity.getTimeType())).collect(Collectors.toList());
        timeEntities.forEach(entity -> {
            HashSet typeList = Sets.newHashSet((Object[])new String[]{entity.getTimeType()});
            if (OvertimeTimeType.ALL_DAY.getDictCode().equals(entity.getTimeType())) {
                typeList.add(OvertimeTimeType.FORENOON.getDictCode());
                typeList.add(OvertimeTimeType.AFTERNOON.getDictCode());
            }
            typeList.forEach(type -> Validate.isTrue((!repeatTimeList.contains(String.format("%s%s", entity.getItemTime(), type)) ? 1 : 0) != 0, (String)String.format("\u5df2\u5b58\u5728%s\u7684\u7533\u8bf7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\uff01", entity.getItemTime()), (Object[])new Object[0]));
        });
    }
}

