/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.overtime.local.service.internal;

import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyTimeEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyTimeRepository;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyTimeService;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import com.biz.crm.sfa.business.overtime.sdk.enums.OvertimeTimeType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="overtimeApplyTimeService")
public class OvertimeApplyTimeServiceImpl
implements OvertimeApplyTimeService {
    private static final Logger log = LoggerFactory.getLogger(OvertimeApplyTimeServiceImpl.class);
    @Autowired
    private OvertimeApplyTimeRepository overtimeApplyTimeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<OvertimeApplyTimeEntity> buildTimeEntities(List<OvertimeApplyTimeDto> timeList) {
        if (CollectionUtils.isEmpty(timeList)) {
            return Lists.newLinkedList();
        }
        timeList.sort(Comparator.comparing(OvertimeApplyTimeDto::getItemTime));
        ArrayList list = Lists.newArrayList();
        list.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(timeList, OvertimeApplyTimeDto.class, OvertimeApplyTimeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        OvertimeApplyTimeDto startTimeDto = timeList.get(0);
        OvertimeApplyTimeDto endTimeDto = timeList.get(timeList.size() - 1);
        long days = LocalDate.parse(startTimeDto.getItemTime()).until(LocalDate.parse(endTimeDto.getItemTime()), ChronoUnit.DAYS);
        if (days > 1L) {
            for (long i = 1L; i < days; ++i) {
                OvertimeApplyTimeEntity timeEntity = new OvertimeApplyTimeEntity();
                timeEntity.setTimeType(OvertimeTimeType.ALL_DAY.getDictCode());
                timeEntity.setItemTime(LocalDate.parse(startTimeDto.getItemTime()).plusDays(i).format(OvertimeConstant.YYYY_MM_DD));
                list.add(timeEntity);
            }
        }
        list.sort(Comparator.comparing(OvertimeApplyTimeEntity::getItemTime));
        return list;
    }
}

