/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.overtime.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyPageDto;
import com.biz.crm.sfa.business.overtime.sdk.service.OvertimeApplyVoService;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyTimeVo;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OvertimeApplyVoServiceImpl
implements OvertimeApplyVoService {
    private static final Logger log = LoggerFactory.getLogger(OvertimeApplyVoServiceImpl.class);
    @Autowired
    private OvertimeApplyRepository overtimeApplyRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private PositionVoService positionVoService;
    @Autowired
    private UserInfoVoService userInfoVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private UserVoService userVoService;

    public List<OvertimeApplyVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        List entities = this.overtimeApplyRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return Lists.newLinkedList();
        }
        List<OvertimeApplyVo> list = entities.stream().map(entity -> {
            OvertimeApplyVo vo = (OvertimeApplyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, OvertimeApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setTimeList(JSON.parseArray((String)entity.getTimeInfoListJson(), OvertimeApplyTimeVo.class));
            return vo;
        }).collect(Collectors.toList());
        this.perfectUserInfo(list);
        return list;
    }

    public List<OvertimeApplyVo> findByProcessStatus(String processStatus) {
        if (StringUtils.isBlank((CharSequence)processStatus)) {
            return Lists.newLinkedList();
        }
        OvertimeApplyConditionDto overtimeApplyConditionDto = new OvertimeApplyConditionDto();
        overtimeApplyConditionDto.setIncludeProcessStatusList(Collections.singletonList(processStatus));
        overtimeApplyConditionDto.setTenantCode(TenantUtils.getTenantCode());
        List<OvertimeApplyEntity> entities = this.overtimeApplyRepository.findByOvertimeApplyConditionDto(overtimeApplyConditionDto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List<OvertimeApplyVo> list = entities.stream().map(entity -> {
            OvertimeApplyVo vo = (OvertimeApplyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, OvertimeApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setTimeList(JSON.parseArray((String)entity.getTimeInfoListJson(), OvertimeApplyTimeVo.class));
            return vo;
        }).collect(Collectors.toList());
        this.perfectUserInfo(list);
        return list;
    }

    public Page<OvertimeApplyVo> findByConditions(Pageable pageable, OvertimeApplyPageDto dto) {
        List userList;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (OvertimeApplyPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new OvertimeApplyPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserNames((Set)Sets.newHashSet((Object[])new String[]{loginDetails.getAccount()}));
        List positionList = this.positionVoService.findByParentCode(loginDetails.getPostCode());
        if (!CollectionUtils.isEmpty((Collection)positionList) && !CollectionUtils.isEmpty((Collection)(userList = this.userInfoVoService.findByPositionCodes(positionList.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet()))))) {
            dto.getUserNames().addAll(userList.stream().map(UserInfoVo::getUserName).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getKeyWord())) {
            UserConditionDto userConditionDto = new UserConditionDto();
            userConditionDto.setFullName(dto.getKeyWord());
            dto.setKeyWordUserNames(this.userVoService.findUserNamesByUserConditionDto(userConditionDto));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateStart())) {
            dto.setApplyDateStart(String.format("%s %s", dto.getApplyDateStart(), "00:00:00"));
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplyDateEnd())) {
            dto.setApplyDateEnd(String.format("%s %s", dto.getApplyDateEnd(), "23:59:59"));
        }
        Page<OvertimeApplyEntity> entityPage = this.overtimeApplyRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), OvertimeApplyEntity.class, OvertimeApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectUserInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    public Page<OvertimeApplyVo> findDetailsByConditions(Pageable pageable, OvertimeApplyPageDto dto) {
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setTenantCode(loginUserDetails.getTenantCode());
        Page<OvertimeApplyEntity> entityPage = this.overtimeApplyRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), OvertimeApplyEntity.class, OvertimeApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectUserInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    public List<OvertimeApplyTimeVo> findOvertimeApplyTimeByConditions(OvertimeApplyConditionDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        if (CollectionUtils.isEmpty((Collection)dto.getUserNames()) || CollectionUtils.isEmpty((Collection)dto.getIncludeProcessStatusList())) {
            return Lists.newArrayList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<OvertimeApplyEntity> entities = this.overtimeApplyRepository.findByOvertimeApplyConditionDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        ArrayList<OvertimeApplyTimeVo> overtimeApplyTimeVos = new ArrayList<OvertimeApplyTimeVo>();
        entities.forEach(entity -> {
            List overtimeApplyTimeVoList = JSON.parseArray((String)entity.getTimeInfoListJson(), OvertimeApplyTimeVo.class);
            for (OvertimeApplyTimeVo overtimeApplyTimeVo : overtimeApplyTimeVoList) {
                overtimeApplyTimeVo.setUserName(entity.getUserName());
            }
            overtimeApplyTimeVos.addAll(overtimeApplyTimeVoList);
        });
        return overtimeApplyTimeVos;
    }

    private void perfectUserInfo(List<OvertimeApplyVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Set userNames = list.stream().map(OvertimeApplyVo::getUserName).collect(Collectors.toSet());
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList(userNames));
        if (CollectionUtils.isEmpty((Collection)userVoList)) {
            return;
        }
        Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
        list.forEach(vo -> {
            UserVo userVo = userMap.getOrDefault(vo.getUserName(), new UserVo());
            vo.setPositionCode(userVo.getPositionCode());
            vo.setPositionName(userVo.getPositionName());
            vo.setOrgCode(userVo.getOrgCode());
            vo.setOrgName(userVo.getOrgName());
            vo.setUserRealName(userVo.getFullName());
        });
    }
}

