/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.overtime.local.service.notifier;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleNoWorkAbideDataDto;
import com.biz.crm.sfa.business.attendance.sdk.event.AttendanceRuleEventListener;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideDataVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleNoWorkAbideVo;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeRuleEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeRuleRepository;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyConditionDto;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class OvertimeAttendanceRuleEventListenerImpl
implements AttendanceRuleEventListener {
    @Autowired
    private OvertimeRuleRepository overtimeRuleRepository;
    @Autowired
    private OvertimeApplyRepository overtimeApplyRepository;

    @Transactional
    public void onCreate(AttendanceRuleVo vo) {
        OvertimeRuleEntity ruleEntity = this.convertVoToEntity(vo);
        if (Objects.isNull((Object)ruleEntity)) {
            return;
        }
        this.overtimeRuleRepository.save((Object)ruleEntity);
    }

    @Transactional
    public void onUpdate(AttendanceRuleVo oldVo, AttendanceRuleVo newVo) {
        this.overtimeRuleRepository.deleteByRuleCodes(Sets.newHashSet((Object[])new String[]{oldVo.getRuleCode()}), TenantUtils.getTenantCode());
        OvertimeRuleEntity ruleEntity = this.convertVoToEntity(newVo);
        if (Objects.isNull((Object)ruleEntity)) {
            return;
        }
        this.overtimeRuleRepository.save((Object)ruleEntity);
    }

    @Transactional
    public void onDisable(List<AttendanceRuleVo> voList) {
    }

    @Transactional
    public void onEnable(List<AttendanceRuleVo> voList) {
    }

    @Transactional
    public void onDelete(List<AttendanceRuleVo> voList) {
        Set<String> ruleCodes = voList.stream().map(AttendanceRuleVo::getRuleCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return;
        }
        this.overtimeRuleRepository.deleteByRuleCodes(ruleCodes, TenantUtils.getTenantCode());
    }

    public List<AttendanceRuleNoWorkAbideVo> onRequestByRuleCodes(Set<String> ruleCodes) {
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return Lists.newLinkedList();
        }
        List<OvertimeRuleEntity> ruleEntities = this.overtimeRuleRepository.findByRuleCodes(Sets.newHashSet(ruleCodes), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(ruleEntities)) {
            return Lists.newLinkedList();
        }
        return ruleEntities.stream().map(overtimeRuleEntity -> {
            AttendanceRuleNoWorkAbideVo noWorkAbideVo = new AttendanceRuleNoWorkAbideVo();
            noWorkAbideVo.setKey("overtime");
            noWorkAbideVo.setRuleCode(overtimeRuleEntity.getRuleCode());
            noWorkAbideVo.setAbideFlag(overtimeRuleEntity.getAbideFlag());
            return noWorkAbideVo;
        }).collect(Collectors.toList());
    }

    public List<AttendanceRuleNoWorkAbideDataVo> onRequestByRuleNoWorkAbideDataDto(RuleNoWorkAbideDataDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getRuleCodes()) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getRuleDate(), dto.getUserName()})) {
            return Lists.newLinkedList();
        }
        OvertimeApplyConditionDto conditionDto = new OvertimeApplyConditionDto();
        conditionDto.setUserName(dto.getUserName());
        conditionDto.setQueryDate(dto.getRuleDate());
        conditionDto.setTenantCode(TenantUtils.getTenantCode());
        conditionDto.setRuleCodes(dto.getRuleCodes());
        conditionDto.setIncludeProcessStatusList((List)Lists.newArrayList((Object[])new String[]{ActApproveStatusEnum.CREATE.getCode(), ActApproveStatusEnum.APPROVING.getCode(), ActApproveStatusEnum.APPROVED.getCode()}));
        List<OvertimeApplyEntity> applyEntities = this.overtimeApplyRepository.findByOvertimeApplyConditionDto(conditionDto);
        HashMap applyEntityMap = CollectionUtils.isEmpty(applyEntities) ? Maps.newHashMap() : applyEntities.stream().collect(Collectors.groupingBy(OvertimeApplyEntity::getRuleCode));
        return dto.getRuleCodes().stream().map(ruleCode -> {
            String currentHaveAbideData = CollectionUtils.isEmpty((Collection)((Collection)applyEntityMap.get(ruleCode))) ? BooleanEnum.FALSE.getCapital() : BooleanEnum.TRUE.getCapital();
            AttendanceRuleNoWorkAbideDataVo abideDataVo = new AttendanceRuleNoWorkAbideDataVo();
            abideDataVo.setKey("overtime");
            abideDataVo.setRuleCode(ruleCode);
            abideDataVo.setCurrentHaveAbideData(currentHaveAbideData);
            return abideDataVo;
        }).collect(Collectors.toList());
    }

    private OvertimeRuleEntity convertVoToEntity(AttendanceRuleVo vo) {
        Validate.notNull((Object)vo, (String)"\u7f3a\u5931\u53c2\u6570\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)vo.getRuleCode(), (String)"\u7f3a\u5931\u89c4\u5219\u7f16\u7801", (Object[])new Object[0]);
        List noWorkAbideInfoList = vo.getNoWorkAbideInfoList();
        if (CollectionUtils.isEmpty((Collection)noWorkAbideInfoList)) {
            return null;
        }
        List ruleOvertimeList = noWorkAbideInfoList.stream().filter(noWorkAbideVo -> "overtime".equals(noWorkAbideVo.getKey())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ruleOvertimeList)) {
            return null;
        }
        AttendanceRuleNoWorkAbideVo workAbideVo = (AttendanceRuleNoWorkAbideVo)ruleOvertimeList.get(0);
        Validate.notBlank((CharSequence)workAbideVo.getAbideFlag(), (String)"\u7f3a\u5931\u662f\u5426\u9075\u5b88\u6b64\u89c4\u5219", (Object[])new Object[0]);
        OvertimeRuleEntity overtimeRuleEntity = new OvertimeRuleEntity();
        overtimeRuleEntity.setAbideFlag(workAbideVo.getAbideFlag());
        overtimeRuleEntity.setRuleCode(vo.getRuleCode());
        overtimeRuleEntity.setTenantCode(TenantUtils.getTenantCode());
        return overtimeRuleEntity;
    }
}

