/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.overtime.local.service.observer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyTimeEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyTimeRepository;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyTimeService;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import com.biz.crm.sfa.business.overtime.sdk.event.OvertimeApplyEventListener;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class OvertimeApplyCallbackListener
implements CallBackListener {
    @Autowired
    private OvertimeApplyRepository overtimeApplyRepository;
    @Autowired
    private OvertimeApplyTimeRepository overtimeApplyTimeRepository;
    @Autowired
    private OvertimeApplyTimeService overtimeApplyTimeService;
    @Autowired(required=false)
    private List<OvertimeApplyEventListener> listeners;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void onCallBack(CallBackDto dto) {
        if (!dto.getFormType().equals("overtime_apply")) {
            return;
        }
        OvertimeApplyEntity applyEntity = this.overtimeApplyRepository.findByProcessNumber(dto.getProcessNo(), TenantUtils.getTenantCode());
        if (Objects.isNull((Object)applyEntity)) {
            return;
        }
        Validate.isTrue((boolean)applyEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), (String)"\u6b64\u7533\u8bf7\u975e\u5ba1\u6279\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessState()), (CharSequence)ActApproveStatusEnum.APPROVED.getCode())) {
            applyEntity.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
            applyEntity.setAuditPassDate(LocalDateTime.now().format(OvertimeConstant.YYYY_MM_DD_HH_MM_SS));
            List timeList = JSON.parseArray((String)applyEntity.getTimeInfoListJson(), OvertimeApplyTimeDto.class);
            List<OvertimeApplyTimeEntity> timeEntities = this.overtimeApplyTimeService.buildTimeEntities(timeList);
            timeEntities.forEach(entity -> entity.setApplyId(applyEntity.getId()));
            this.overtimeApplyTimeRepository.saveBatch(timeEntities);
            if (!CollectionUtils.isEmpty(this.listeners)) {
                OvertimeApplyVo overtimeApplyVo = (OvertimeApplyVo)this.nebulaToolkitService.copyObjectByBlankList((Object)applyEntity, OvertimeApplyVo.class, HashSet.class, ArrayList.class, new String[0]);
                this.listeners.forEach(listener -> listener.onApproved(overtimeApplyVo));
            }
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessState()), (CharSequence)ActApproveStatusEnum.REJECTED.getCode())) {
            applyEntity.setProcessStatus(ActApproveStatusEnum.REJECTED.getCode());
        } else if (StringUtils.equals((CharSequence)String.valueOf(dto.getProcessState()), (CharSequence)ActApproveStatusEnum.INTERRUPT.getCode())) {
            applyEntity.setProcessStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        }
        this.overtimeApplyRepository.updateById((Object)applyEntity);
    }
}

