package com.biz.crm.sfa.business.overtime.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 加班考勤规则关系实体类
 *
 * @author ning.zhang
 * @date 2022/5/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OvertimeApplyEntity", description = "加班考勤规则关系实体类")
@Entity
@TableName("sfa_overtime_rule")
@Table(name = "sfa_overtime_rule", indexes = {
    @Index(name = "sfa_overtime_rule_index1", columnList = "rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_overtime_rule", comment = "加班考勤规则关系表")
public class OvertimeRuleEntity extends TenantEntity {

  private static final long serialVersionUID = -7228378362718421268L;

  /**
   * 考勤规则编码
   */
  @ApiModelProperty("考勤规则编码")
  @Column(name = "rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '考勤规则编码'")
  private String ruleCode;

  /**
   * 是否遵守此规则(Y:是;N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty(value = "是否遵守此规则(Y:是;N:否)")
  @Column(name = "abide_flag", length = 20, nullable = false, columnDefinition = "VARCHAR(20) NOT NULL COMMENT '是否遵守此规则(Y:是;N:否)'")
  private String abideFlag;
}
