package com.biz.crm.sfa.business.overtime.local.observer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyEntity;
import com.biz.crm.sfa.business.overtime.local.entity.OvertimeApplyTimeEntity;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyRepository;
import com.biz.crm.sfa.business.overtime.local.repository.OvertimeApplyTimeRepository;
import com.biz.crm.sfa.business.overtime.local.service.OvertimeApplyTimeService;
import com.biz.crm.sfa.business.overtime.sdk.constant.OvertimeConstant;
import com.biz.crm.sfa.business.overtime.sdk.dto.OvertimeApplyTimeDto;
import com.biz.crm.sfa.business.overtime.sdk.event.OvertimeApplyEventListener;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 加班审批回调类
 *
 * @author ning.zhang
 * @date 2022/6/2
 */
@Component
public class OvertimeApplyProcessCompleteListener implements ProcessCompleteListener {

  @Autowired
  private OvertimeApplyRepository overtimeApplyRepository;
  @Autowired
  private OvertimeApplyTimeRepository overtimeApplyTimeRepository;
  @Autowired
  private OvertimeApplyTimeService overtimeApplyTimeService;
  @Autowired(required = false)
  private List<OvertimeApplyEventListener> listeners;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getBusinessCode() {
    return OvertimeConstant.OVERTIME_APPLY_PROCESS_FORM_TYPE;
  }

  @Override
  @Transactional
  public void onProcessComplete(ProcessStatusDto dto) {
    if (!dto.getBusinessCode().equals(OvertimeConstant.OVERTIME_APPLY_PROCESS_FORM_TYPE)) {
      return;
    }
    OvertimeApplyEntity applyEntity = this.overtimeApplyRepository.findByApplyCode(dto.getBusinessNo(), TenantUtils.getTenantCode());
    Validate.notNull(applyEntity, "加班申请记录不存在！");
    //根据回调类别处理对应业务
    if (ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
      //审批通过业务处理
      applyEntity.setAuditPassDate(LocalDateTime.now().format(OvertimeConstant.YYYY_MM_DD_HH_MM_SS));
      List<OvertimeApplyTimeDto> timeList = JSON.parseArray(applyEntity.getTimeInfoListJson(), OvertimeApplyTimeDto.class);
      List<OvertimeApplyTimeEntity> timeEntities = this.overtimeApplyTimeService.buildTimeEntities(timeList);
      timeEntities.forEach(entity -> entity.setApplyId(applyEntity.getId()));
      this.overtimeApplyTimeRepository.saveBatch(timeEntities);
      //发起事件通知上层模块
      if (!CollectionUtils.isEmpty(listeners)) {
        OvertimeApplyVo overtimeApplyVo = this.nebulaToolkitService.copyObjectByBlankList(applyEntity
            , OvertimeApplyVo.class, HashSet.class, ArrayList.class);
        this.listeners.forEach(listener -> listener.onApproved(overtimeApplyVo));
      }
      this.overtimeApplyRepository.updateById(applyEntity);
    }
  }
}
